/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.ComparisonFailure;
import org.junit.internal.ArrayComparisonFailure;
import org.junit.internal.ExactComparisonCriteria;
import org.junit.internal.InexactComparisonCriteria;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Assert {
    protected Assert() {
    }

    public static void assertTrue(String message, boolean condition) {
        if (!condition) {
            Assert.fail((String)message);
        }
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue(null, (boolean)condition);
    }

    public static void assertFalse(String message, boolean condition) {
        Assert.assertTrue((String)message, (!condition ? 1 : 0) != 0);
    }

    public static void assertFalse(boolean condition) {
        Assert.assertFalse(null, (boolean)condition);
    }

    public static void fail(String message) {
        if (message == null) {
            throw new AssertionError();
        }
        throw new AssertionError((Object)message);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (Assert.equalsRegardingNull((Object)expected, (Object)actual)) {
            return;
        }
        if (expected instanceof String && actual instanceof String) {
            String cleanMessage = message == null ? "" : message;
            throw new ComparisonFailure(cleanMessage, (String)expected, (String)actual);
        }
        Assert.failNotEquals((String)message, (Object)expected, (Object)actual);
    }

    private static boolean equalsRegardingNull(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        return Assert.isEquals((Object)expected, (Object)actual);
    }

    private static boolean isEquals(Object expected, Object actual) {
        return expected.equals(actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals(null, (Object)expected, (Object)actual);
    }

    public static void assertNotEquals(String message, Object unexpected, Object actual) {
        if (Assert.equalsRegardingNull((Object)unexpected, (Object)actual)) {
            Assert.failEquals((String)message, (Object)actual);
        }
    }

    public static void assertNotEquals(Object unexpected, Object actual) {
        Assert.assertNotEquals(null, (Object)unexpected, (Object)actual);
    }

    private static void failEquals(String message, Object actual) {
        String formatted = "Values should be different. ";
        if (message != null) {
            formatted = message + ". ";
        }
        formatted = formatted + "Actual: " + actual;
        Assert.fail((String)formatted);
    }

    public static void assertNotEquals(String message, long unexpected, long actual) {
        Assert.assertNotEquals((String)message, (Object)unexpected, (Object)actual);
    }

    public static void assertNotEquals(long unexpected, long actual) {
        Assert.assertNotEquals(null, (long)unexpected, (long)actual);
    }

    public static void assertNotEquals(String message, double unexpected, double actual, double delta) {
        if (!Assert.doubleIsDifferent((double)unexpected, (double)actual, (double)delta)) {
            Assert.failEquals((String)message, (Object)new Double(actual));
        }
    }

    public static void assertNotEquals(double unexpected, double actual, double delta) {
        Assert.assertNotEquals(null, (double)unexpected, (double)actual, (double)delta);
    }

    public static void assertNotEquals(float unexpected, float actual, float delta) {
        Assert.assertNotEquals(null, (float)unexpected, (float)actual, (float)delta);
    }

    public static void assertArrayEquals(String message, Object[] expecteds, Object[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals((String)message, (Object)expecteds, (Object)actuals);
    }

    public static void assertArrayEquals(Object[] expecteds, Object[] actuals) {
        Assert.assertArrayEquals(null, (Object[])expecteds, (Object[])actuals);
    }

    public static void assertArrayEquals(String message, boolean[] expecteds, boolean[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals((String)message, (Object)expecteds, (Object)actuals);
    }

    public static void assertArrayEquals(boolean[] expecteds, boolean[] actuals) {
        Assert.assertArrayEquals(null, (boolean[])expecteds, (boolean[])actuals);
    }

    public static void assertArrayEquals(String message, byte[] expecteds, byte[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals((String)message, (Object)expecteds, (Object)actuals);
    }

    public static void assertArrayEquals(byte[] expecteds, byte[] actuals) {
        Assert.assertArrayEquals(null, (byte[])expecteds, (byte[])actuals);
    }

    public static void assertArrayEquals(String message, char[] expecteds, char[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals((String)message, (Object)expecteds, (Object)actuals);
    }

    public static void assertArrayEquals(char[] expecteds, char[] actuals) {
        Assert.assertArrayEquals(null, (char[])expecteds, (char[])actuals);
    }

    public static void assertArrayEquals(String message, short[] expecteds, short[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals((String)message, (Object)expecteds, (Object)actuals);
    }

    public static void assertArrayEquals(short[] expecteds, short[] actuals) {
        Assert.assertArrayEquals(null, (short[])expecteds, (short[])actuals);
    }

    public static void assertArrayEquals(String message, int[] expecteds, int[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals((String)message, (Object)expecteds, (Object)actuals);
    }

    public static void assertArrayEquals(int[] expecteds, int[] actuals) {
        Assert.assertArrayEquals(null, (int[])expecteds, (int[])actuals);
    }

    public static void assertArrayEquals(String message, long[] expecteds, long[] actuals) throws ArrayComparisonFailure {
        Assert.internalArrayEquals((String)message, (Object)expecteds, (Object)actuals);
    }

    public static void assertArrayEquals(long[] expecteds, long[] actuals) {
        Assert.assertArrayEquals(null, (long[])expecteds, (long[])actuals);
    }

    public static void assertArrayEquals(String message, double[] expecteds, double[] actuals, double delta) throws ArrayComparisonFailure {
        new InexactComparisonCriteria(delta).arrayEquals(message, (Object)expecteds, (Object)actuals);
    }

    public static void assertArrayEquals(double[] expecteds, double[] actuals, double delta) {
        Assert.assertArrayEquals(null, (double[])expecteds, (double[])actuals, (double)delta);
    }

    public static void assertArrayEquals(String message, float[] expecteds, float[] actuals, float delta) throws ArrayComparisonFailure {
        new InexactComparisonCriteria(delta).arrayEquals(message, (Object)expecteds, (Object)actuals);
    }

    public static void assertArrayEquals(float[] expecteds, float[] actuals, float delta) {
        Assert.assertArrayEquals(null, (float[])expecteds, (float[])actuals, (float)delta);
    }

    private static void internalArrayEquals(String message, Object expecteds, Object actuals) throws ArrayComparisonFailure {
        new ExactComparisonCriteria().arrayEquals(message, expecteds, actuals);
    }

    public static void assertEquals(String message, double expected, double actual, double delta) {
        if (Assert.doubleIsDifferent((double)expected, (double)actual, (double)delta)) {
            Assert.failNotEquals((String)message, (Object)new Double(expected), (Object)new Double(actual));
        }
    }

    public static void assertEquals(String message, float expected, float actual, float delta) {
        if (Assert.floatIsDifferent((float)expected, (float)actual, (float)delta)) {
            Assert.failNotEquals((String)message, (Object)new Float(expected), (Object)new Float(actual));
        }
    }

    public static void assertNotEquals(String message, float unexpected, float actual, float delta) {
        if (!Assert.floatIsDifferent((float)unexpected, (float)actual, (float)delta)) {
            Assert.failEquals((String)message, (Object)new Float(actual));
        }
    }

    private static boolean doubleIsDifferent(double d1, double d2, double delta) {
        if (Double.compare(d1, d2) == 0) {
            return false;
        }
        return !(Math.abs(d1 - d2) <= delta);
    }

    private static boolean floatIsDifferent(float f1, float f2, float delta) {
        if (Float.compare(f1, f2) == 0) {
            return false;
        }
        return !(Math.abs(f1 - f2) <= delta);
    }

    public static void assertEquals(long expected, long actual) {
        Assert.assertEquals(null, (long)expected, (long)actual);
    }

    public static void assertEquals(String message, long expected, long actual) {
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    @Deprecated
    public static void assertEquals(double expected, double actual) {
        Assert.assertEquals(null, (double)expected, (double)actual);
    }

    @Deprecated
    public static void assertEquals(String message, double expected, double actual) {
        Assert.fail((String)"Use assertEquals(expected, actual, delta) to compare floating-point numbers");
    }

    public static void assertEquals(double expected, double actual, double delta) {
        Assert.assertEquals(null, (double)expected, (double)actual, (double)delta);
    }

    public static void assertEquals(float expected, float actual, float delta) {
        Assert.assertEquals(null, (float)expected, (float)actual, (float)delta);
    }

    public static void assertNotNull(String message, Object object) {
        Assert.assertTrue((String)message, (object != null ? 1 : 0) != 0);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(null, (Object)object);
    }

    public static void assertNull(String message, Object object) {
        if (object == null) {
            return;
        }
        Assert.failNotNull((String)message, (Object)object);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(null, (Object)object);
    }

    private static void failNotNull(String message, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail((String)(formatted + "expected null, but was:<" + actual + ">"));
    }

    public static void assertSame(String message, Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        Assert.failNotSame((String)message, (Object)expected, (Object)actual);
    }

    public static void assertSame(Object expected, Object actual) {
        Assert.assertSame(null, (Object)expected, (Object)actual);
    }

    public static void assertNotSame(String message, Object unexpected, Object actual) {
        if (unexpected == actual) {
            Assert.failSame((String)message);
        }
    }

    public static void assertNotSame(Object unexpected, Object actual) {
        Assert.assertNotSame(null, (Object)unexpected, (Object)actual);
    }

    private static void failSame(String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail((String)(formatted + "expected not same"));
    }

    private static void failNotSame(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail((String)(formatted + "expected same:<" + expected + "> was not:<" + actual + ">"));
    }

    private static void failNotEquals(String message, Object expected, Object actual) {
        Assert.fail((String)Assert.format((String)message, (Object)expected, (Object)actual));
    }

    static String format(String message, Object expected, Object actual) {
        String actualString;
        String expectedString;
        String formatted = "";
        if (message != null && !message.equals("")) {
            formatted = message + " ";
        }
        if ((expectedString = String.valueOf(expected)).equals(actualString = String.valueOf(actual))) {
            return formatted + "expected: " + Assert.formatClassAndValue((Object)expected, (String)expectedString) + " but was: " + Assert.formatClassAndValue((Object)actual, (String)actualString);
        }
        return formatted + "expected:<" + expectedString + "> but was:<" + actualString + ">";
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return className + "<" + valueString + ">";
    }

    @Deprecated
    public static void assertEquals(String message, Object[] expecteds, Object[] actuals) {
        Assert.assertArrayEquals((String)message, (Object[])expecteds, (Object[])actuals);
    }

    @Deprecated
    public static void assertEquals(Object[] expecteds, Object[] actuals) {
        Assert.assertArrayEquals((Object[])expecteds, (Object[])actuals);
    }

    public static <T> void assertThat(T actual, Matcher<? super T> matcher) {
        Assert.assertThat((String)"", actual, matcher);
    }

    public static <T> void assertThat(String reason, T actual, Matcher<? super T> matcher) {
        MatcherAssert.assertThat((String)reason, actual, matcher);
    }
}

