/*
 * Decompiled with CFR 0.152.
 */
package util;

import junit.framework.TestCase;
import util.CommandLine;
import util.Option;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommandLineTest
extends TestCase {
    private CommandLine options;

    public void testSimpleParsing() throws Exception {
        CommandLineTest.assertTrue((boolean)this.createOptionsAndParse("", ""));
        CommandLineTest.assertFalse((boolean)this.createOptionsAndParse("", "blah"));
    }

    public void testOneRequiredArgument() throws Exception {
        CommandLineTest.assertFalse((boolean)this.createOptionsAndParse("arg1", ""));
        CommandLineTest.assertTrue((boolean)this.createOptionsAndParse("arg1", "blah"));
        CommandLineTest.assertEquals((String)"blah", (String)this.options.getArgument("arg1"));
    }

    public void testThreeRequiredArguments() throws Exception {
        CommandLineTest.assertTrue((boolean)this.createOptionsAndParse("arg1 arg2 arg3", "tic tac toe"));
        CommandLineTest.assertEquals((String)"tic", (String)this.options.getArgument("arg1"));
        CommandLineTest.assertEquals((String)"tac", (String)this.options.getArgument("arg2"));
        CommandLineTest.assertEquals((String)"toe", (String)this.options.getArgument("arg3"));
    }

    public void testOneSimpleOption() throws Exception {
        CommandLineTest.assertTrue((boolean)this.createOptionsAndParse("[-opt1]", ""));
        CommandLineTest.assertFalse((boolean)this.options.hasOption("opt1"));
        CommandLineTest.assertTrue((boolean)this.createOptionsAndParse("[-opt1]", "-opt1"));
        CommandLineTest.assertTrue((boolean)this.options.hasOption("opt1"));
    }

    public void testOptionWithArgument() throws Exception {
        CommandLineTest.assertFalse((boolean)this.createOptionsAndParse("[-opt1 arg]", "-opt1"));
        CommandLineTest.assertTrue((boolean)this.createOptionsAndParse("[-opt1 arg]", "-opt1 blah"));
        CommandLineTest.assertTrue((boolean)this.options.hasOption("opt1"));
        String argument = this.options.getOptionArgument("opt1", "arg");
        CommandLineTest.assertNotNull((Object)argument);
        CommandLineTest.assertEquals((String)"blah", (String)argument);
    }

    public void testMultipleOptions() {
        this.options = new CommandLine("[-opt1 arg]");
        String[] args = new Option().split("-opt1 blah");
        CommandLineTest.assertTrue((boolean)this.options.parse(args));
        this.options.hasOption("opt1");
        CommandLineTest.assertEquals((String)"blah", (String)this.options.getOptionArgument("opt1", "arg"));
    }

    public void testInvalidOption() throws Exception {
        CommandLineTest.assertFalse((boolean)this.createOptionsAndParse("", "-badArg"));
    }

    public void testCombo() throws Exception {
        String descriptor = "[-opt1 arg1 arg2] [-opt2 arg1] [-opt3] arg1 arg2";
        CommandLineTest.assertFalse((boolean)this.createOptionsAndParse(descriptor, ""));
        CommandLineTest.assertFalse((boolean)this.createOptionsAndParse(descriptor, "a"));
        CommandLineTest.assertFalse((boolean)this.createOptionsAndParse(descriptor, "-opt1 a b c"));
        CommandLineTest.assertFalse((boolean)this.createOptionsAndParse(descriptor, "-opt2 a b"));
        CommandLineTest.assertFalse((boolean)this.createOptionsAndParse(descriptor, "-opt2 -opt3 a b"));
        CommandLineTest.assertFalse((boolean)this.createOptionsAndParse(descriptor, "-opt1 a -opt2 b -opt3 c d"));
        CommandLineTest.assertFalse((boolean)this.createOptionsAndParse(descriptor, "-opt1 a b -opt2 c -opt3 d e f"));
        CommandLineTest.assertTrue((boolean)this.createOptionsAndParse(descriptor, "a b"));
        CommandLineTest.assertTrue((boolean)this.createOptionsAndParse(descriptor, "-opt3 a b"));
        CommandLineTest.assertTrue((boolean)this.createOptionsAndParse(descriptor, "-opt2 a b c"));
        CommandLineTest.assertTrue((boolean)this.createOptionsAndParse(descriptor, "-opt1 a b c d"));
        CommandLineTest.assertTrue((boolean)this.createOptionsAndParse(descriptor, "-opt1 a b -opt2 c d e"));
        CommandLineTest.assertTrue((boolean)this.createOptionsAndParse(descriptor, "-opt1 a b -opt2 c -opt3 d e"));
        CommandLineTest.assertTrue((boolean)this.options.hasOption("opt1"));
        CommandLineTest.assertEquals((String)"a", (String)this.options.getOptionArgument("opt1", "arg1"));
        CommandLineTest.assertEquals((String)"b", (String)this.options.getOptionArgument("opt1", "arg2"));
        CommandLineTest.assertTrue((boolean)this.options.hasOption("opt2"));
        CommandLineTest.assertEquals((String)"c", (String)this.options.getOptionArgument("opt2", "arg1"));
        CommandLineTest.assertTrue((boolean)this.options.hasOption("opt3"));
        CommandLineTest.assertEquals((String)"d", (String)this.options.getArgument("arg1"));
        CommandLineTest.assertEquals((String)"e", (String)this.options.getArgument("arg2"));
    }

    private boolean createOptionsAndParse(String validOptions, String enteredOptions) {
        this.options = new CommandLine(validOptions);
        String[] args = new Option().split(enteredOptions);
        return this.options.parse(args);
    }
}

