/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.dependency.tree.filter;

import java.util.Collections;
import java.util.List;
import org.scijava.maven.plugin.dependency.tree.DependencyNode;
import org.scijava.maven.plugin.dependency.tree.filter.DependencyNodeFilter;

public class AncestorOrSelfDependencyNodeFilter
implements DependencyNodeFilter {
    private final List<DependencyNode> descendantNodes;

    public AncestorOrSelfDependencyNodeFilter(DependencyNode descendantNode) {
        this(Collections.singletonList(descendantNode));
    }

    public AncestorOrSelfDependencyNodeFilter(List<DependencyNode> descendantNodes) {
        this.descendantNodes = descendantNodes;
    }

    @Override
    public boolean accept(DependencyNode node) {
        for (DependencyNode descendantNode : this.descendantNodes) {
            if (!this.isAncestorOrSelf(node, descendantNode)) continue;
            return true;
        }
        return false;
    }

    private boolean isAncestorOrSelf(DependencyNode ancestorNode, DependencyNode descendantNode) {
        boolean ancestor = false;
        while (!ancestor && descendantNode != null) {
            ancestor = ancestorNode.equals(descendantNode);
            descendantNode = descendantNode.getParent();
        }
        return ancestor;
    }
}

