/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.enforcer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jdepend.framework.JDepend;
import jdepend.framework.JavaPackage;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.scijava.maven.plugin.enforcer.AbstractPackageEnforcementRule;
import org.scijava.maven.plugin.enforcer.SubpackageDependenceOutput;

public class NoSubpackageDependenceRule
extends AbstractPackageEnforcementRule {
    @Override
    void enforceRule(JDepend jdepend) throws EnforcerRuleException {
        HashMap subpackageLists = new HashMap();
        for (JavaPackage p : jdepend.getPackages()) {
            ArrayList<JavaPackage> subpackages = new ArrayList<JavaPackage>();
            for (JavaPackage other : subpackageLists.keySet()) {
                String oString;
                String dString = p.getName();
                if (dString == (oString = other.getName())) continue;
                if (dString.startsWith(oString)) {
                    ((List)subpackageLists.get(other)).add(p);
                }
                if (!oString.startsWith(dString)) continue;
                subpackages.add(other);
            }
            subpackageLists.put(p, subpackages);
        }
        HashMap<JavaPackage, List<JavaPackage>> subpackageDependence = new HashMap<JavaPackage, List<JavaPackage>>();
        for (Map.Entry e : subpackageLists.entrySet()) {
            Collection efferents = ((JavaPackage)e.getKey()).getEfferents();
            List subpackagesDependedUpon = efferents.stream().filter(((List)e.getValue())::contains).collect(Collectors.toList());
            subpackageDependence.put((JavaPackage)e.getKey(), subpackagesDependedUpon);
        }
        for (List l : subpackageDependence.values()) {
            if (l.isEmpty()) continue;
            throw new EnforcerRuleException("Some packages depend on subpackages:" + new SubpackageDependenceOutput(subpackageDependence).getOutput());
        }
    }
}

