/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.install;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.resolve.AbstractFilter;
import org.apache.maven.shared.artifact.filter.resolve.AndFilter;
import org.apache.maven.shared.artifact.filter.resolve.Node;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.util.FileUtils;
import org.scijava.maven.plugin.install.KnownPlatforms;
import org.scijava.maven.plugin.install.SubdirectoryPattern;
import org.scijava.util.VersionUtils;

public abstract class AbstractInstallMojo
extends AbstractMojo {
    @Parameter(property="scijava.app.directory", required=false)
    String appDirectory;
    @Parameter(property="scijava.app.subdirectory", required=false)
    String appSubdirectory;
    @Parameter(property="scijava.deleteOtherVersions", defaultValue="older")
    OtherVersions deleteOtherVersionsPolicy;
    @Parameter(property="scijava.subdirectoryPatterns", required=false)
    List<SubdirectoryPattern> subdirectoryPatterns;
    @Parameter(property="scijava.ignoreDependencies", defaultValue="false")
    boolean ignoreDependencies;
    @Parameter(defaultValue="${session}")
    MavenSession session;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    MojoExecution mojoExecution;
    protected static final String APP_DIRECTORY_PROPERTY = "scijava.app.directory";
    protected static final String APP_SUBDIRECTORY_PROPERTY = "scijava.app.subdirectory";
    protected static final String DELETE_OTHER_VERSIONS_POLICY_PROPERTY = "scijava.deleteOtherVersions";
    protected static final String SUBDIRECTORY_PATTERNS_PROPERTY = "scijava.subdirectoryPatterns";
    protected static final String IGNORE_DEPENDENCIES_PROPERTY = "scijava.ignoreDependencies";
    protected static final String IGNORE_OPTIONAL_DEPENDENCIES_PROPERTY = "scijava.ignoreOptionalDependencies";

    protected boolean hasIJ1Dependency(MavenProject project) {
        List dependencies = project.getDependencies();
        for (Dependency dependency : dependencies) {
            String artifactId = dependency.getArtifactId();
            if (!"ij".equals(artifactId) && !"imagej".equals(artifactId)) continue;
            return true;
        }
        return false;
    }

    protected String interpolate(String original, MavenProject project) throws MojoExecutionException {
        if (original == null || original.indexOf("${") < 0) {
            return original;
        }
        try {
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
            interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(System.getProperties()));
            ArrayList<String> synonymPrefixes = new ArrayList<String>();
            synonymPrefixes.add("project.");
            synonymPrefixes.add("pom.");
            if (project != null) {
                PrefixedValueSourceWrapper modelWrapper = new PrefixedValueSourceWrapper((ValueSource)new ObjectBasedValueSource((Object)project.getModel()), synonymPrefixes, true);
                interpolator.addValueSource((ValueSource)modelWrapper);
                PrefixedValueSourceWrapper pomPropertyWrapper = new PrefixedValueSourceWrapper((ValueSource)new PropertiesBasedValueSource(project.getModel().getProperties()), synonymPrefixes, true);
                interpolator.addValueSource((ValueSource)pomPropertyWrapper);
            }
            if (this.session != null) {
                interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(this.session.getExecutionProperties()));
            }
            PrefixAwareRecursionInterceptor recursionInterceptor = new PrefixAwareRecursionInterceptor(synonymPrefixes, true);
            return interpolator.interpolate(original, (RecursionInterceptor)recursionInterceptor);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not interpolate '" + original + "'", e);
        }
    }

    protected void installArtifact(Artifact artifact, File appDir, boolean force, OtherVersions otherVersionsPolicy) throws IOException {
        this.installArtifact(artifact, appDir, "", force, otherVersionsPolicy);
    }

    protected void installArtifact(Artifact artifact, File appDir, String appSubdir, boolean force, OtherVersions otherVersionsPolicy) throws IOException {
        String subDir;
        if (!"jar".equals(artifact.getType())) {
            return;
        }
        File source = artifact.getFile();
        File targetDirectory = appSubdir != null && !appSubdir.equals("") ? new File(appDir, appSubdir) : (AbstractInstallMojo.isIJ1Plugin(source) ? new File(appDir, "plugins") : ((subDir = this.subdirectory(artifact)) == null ? new File(appDir, "jars") : new File(appDir, subDir)));
        String fileName = source.getName();
        File target = new File(targetDirectory, fileName);
        boolean newerVersion = false;
        Path targetPath = Paths.get(target.toURI());
        Map<Path, String> otherVersions = this.getEncroachingVersions(targetPath.getParent(), artifact);
        for (Path other : otherVersions.keySet()) {
            Path otherName = other.getFileName();
            switch (otherVersionsPolicy) {
                case never: {
                    this.getLog().warn((CharSequence)("Possibly incompatible version exists: " + otherName));
                    break;
                }
                case older: {
                    String toInstall = artifact.getVersion();
                    String otherVersion = otherVersions.get(other);
                    newerVersion = VersionUtils.compare((String)toInstall, (String)otherVersion) < 0;
                    String majorVersionToInstall = AbstractInstallMojo.majorVersion(toInstall);
                    String majorVersionOther = AbstractInstallMojo.majorVersion(otherVersion);
                    if (!majorVersionToInstall.equals(majorVersionOther)) {
                        this.getLog().warn((CharSequence)("Version " + AbstractInstallMojo.versionToString(otherVersion) + " of " + artifact + " is incompatible according to SemVer: " + majorVersionToInstall + " != " + AbstractInstallMojo.versionToString(majorVersionOther)));
                    }
                    if (newerVersion) break;
                }
                case always: {
                    if (Files.deleteIfExists(other)) {
                        this.getLog().info((CharSequence)("Deleted overridden " + otherName));
                        newerVersion = false;
                        break;
                    }
                    this.getLog().warn((CharSequence)("Could not delete overridden " + otherName));
                }
            }
        }
        if (!force && target.exists() && target.lastModified() > source.lastModified()) {
            this.getLog().info((CharSequence)("Dependency " + fileName + " is already there; skipping"));
        } else if (newerVersion) {
            this.getLog().info((CharSequence)("A newer version for " + fileName + " was detected; skipping"));
        } else {
            this.getLog().info((CharSequence)("Copying " + fileName + " to " + targetDirectory));
            FileUtils.copyFile((File)source, (File)target);
        }
    }

    protected static TransformableFilter makeTransformableFilterDefaultExclusions(boolean ignoreOptionalDependencies) {
        return AbstractInstallMojo.makeTransformableFilter(ignoreOptionalDependencies, "system", "provided", "test");
    }

    protected static TransformableFilter makeTransformableFilter(boolean ignoreOptionalDependencies, String ... excludedScopes) {
        ScopeFilter scopeFilter = ScopeFilter.excluding((String[])excludedScopes);
        if (ignoreOptionalDependencies) {
            AbstractFilter notOptionalFilter = new AbstractFilter(){

                public boolean accept(Node node, List<Node> parents) {
                    return !node.getDependency().isOptional();
                }
            };
            return new AndFilter(Arrays.asList(scopeFilter, notOptionalFilter));
        }
        return scopeFilter;
    }

    private static String versionToString(String v) {
        return v == null || v.isEmpty() ? "(none)" : v;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isIJ1Plugin(File file) {
        String name = file.getName();
        if (name.indexOf(95) < 0) return false;
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            return new File(file, "src/main/resources/plugins.config").exists();
        }
        if (!name.endsWith(".jar")) {
            return false;
        }
        try (JarFile jar = new JarFile(file);){
            JarEntry entry;
            Iterator<JarEntry> iterator = Collections.list(jar.entries()).iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!(entry = iterator.next()).getName().equals("plugins.config"));
            jar.close();
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private String subdirectory(Artifact artifact) {
        if (this.subdirectoryPatterns == null || this.subdirectoryPatterns.isEmpty()) {
            this.getLog().debug((CharSequence)"Using default subdirectory patterns");
            this.subdirectoryPatterns = KnownPlatforms.nativeSubdirectoryPatterns();
        }
        this.getLog().debug((CharSequence)("Checking artifact: " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getClassifier()));
        for (SubdirectoryPattern pattern : this.subdirectoryPatterns) {
            if (pattern.matches(artifact)) {
                this.getLog().debug((CharSequence)("- Versus pattern " + pattern.subdirectory + "? MATCH"));
                return pattern.subdirectory;
            }
            this.getLog().debug((CharSequence)("- Versus pattern " + pattern.subdirectory + "? NOPE"));
        }
        return null;
    }

    private static String majorVersion(String v) {
        int dot = v.indexOf(46);
        return dot < 0 ? v : v.substring(0, dot);
    }

    private Map<Path, String> getEncroachingVersions(Path directory, Artifact artifact) {
        LinkedHashMap<Path, String> result = new LinkedHashMap<Path, String>();
        if (!directory.toFile().exists()) {
            return result;
        }
        if (!directory.toFile().isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + directory);
        }
        String artifactPattern = Pattern.quote(artifact.getArtifactId());
        String normalVersion = "[0-9].*?";
        String jitpackVersion = "[0-9a-f]{5}[0-9a-f]*";
        String versionPattern = "(-[0-9].*?|-[0-9a-f]{5}[0-9a-f]*)?";
        String rawClassifier = artifact.getClassifier();
        String classifier = rawClassifier == null ? "" : rawClassifier;
        ArrayList<String> classifiers = new ArrayList<String>();
        classifiers.add(classifier);
        classifiers.addAll(KnownPlatforms.nativeClassifiers());
        CharSequence[] quotedClassifiers = (String[])classifiers.stream().map(c -> c.isEmpty() ? "" : "-" + Pattern.quote(c)).toArray(String[]::new);
        String classifierPattern = "(" + String.join((CharSequence)"|", quotedClassifiers) + ")?";
        String typePattern = Pattern.quote("." + artifact.getType());
        String patternString = artifactPattern + "(-[0-9].*?|-[0-9a-f]{5}[0-9a-f]*)?" + classifierPattern + typePattern;
        Pattern pattern = Pattern.compile(patternString);
        try {
            Files.walk(directory, 1, new FileVisitOption[0]).forEach(path -> {
                String version = AbstractInstallMojo.getEncroachingVersion(path, pattern, classifier);
                if (version != null) {
                    result.put((Path)path, version);
                }
            });
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        return result;
    }

    private static String getEncroachingVersion(Path path, Pattern pattern, String expectedClassifier) {
        Matcher m = pattern.matcher(path.getFileName().toString());
        if (!m.matches()) {
            return null;
        }
        String classifier = AbstractInstallMojo.trimLeadingDash(m.group(2));
        if (!expectedClassifier.equals(classifier)) {
            return null;
        }
        String version = AbstractInstallMojo.trimLeadingDash(m.group(1));
        return version;
    }

    private static String trimLeadingDash(String s) {
        if (s == null) {
            return "";
        }
        if (s.startsWith("-")) {
            return s.substring(1);
        }
        return s;
    }

    public static enum OtherVersions {
        always,
        older,
        never;

    }
}

