/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.scijava.ops.api.OpMatchingException;
import org.scijava.ops.api.OpRequest;
import org.scijava.ops.engine.matcher.OpCandidate;
import org.scijava.ops.engine.util.Infos;

public class MatchingResult {
    private final List<OpCandidate> candidates;
    private final List<OpCandidate> matches;
    private final List<OpRequest> originalQueries;

    public static MatchingResult empty(List<OpRequest> originalQueries) {
        return new MatchingResult(new ArrayList<OpCandidate>(), new ArrayList<OpCandidate>(), originalQueries);
    }

    public MatchingResult(List<OpCandidate> candidates, List<OpCandidate> matches, List<OpRequest> originalQueries) {
        this.candidates = candidates;
        this.matches = matches;
        this.originalQueries = originalQueries;
    }

    public List<OpRequest> getOriginalQueries() {
        return this.originalQueries;
    }

    public List<OpCandidate> getCandidates() {
        return this.candidates;
    }

    public List<OpCandidate> getMatches() {
        return this.matches;
    }

    public OpCandidate singleMatch() {
        if (this.matches.size() == 1) {
            return this.matches.get(0);
        }
        String analysis = MatchingResult.matchInfo(this);
        throw new OpMatchingException(analysis);
    }

    public static String matchInfo(MatchingResult res) {
        StringBuilder sb = new StringBuilder();
        List<OpCandidate> candidates = res.getCandidates();
        List<OpCandidate> matches = res.getMatches();
        OpRequest request = res.getOriginalQueries().get(0);
        if (matches.isEmpty()) {
            sb.append("No matching '" + request.label() + "' op\n");
        } else {
            double priority = matches.get(0).priority();
            sb.append("Multiple '" + request.label() + "' ops of priority " + priority + ":\n");
            if (MatchingResult.typeCheckingIncomplete(matches)) {
                sb.append("Incomplete output type checking may have occurred!\n");
            }
            int count = 0;
            for (OpCandidate match : matches) {
                sb.append(++count + ". ");
                sb.append(match.toString() + "\n");
            }
        }
        sb.append("\n");
        sb.append("Request:\n");
        sb.append("-\t" + request + "\n");
        sb.append("\n");
        sb.append("Candidates:\n");
        if (candidates.isEmpty()) {
            sb.append("-\t No candidates found!");
        }
        int count = 0;
        for (OpCandidate candidate : candidates) {
            sb.append(++count + ". ");
            sb.append("\t" + Infos.describe(candidate.opInfo()) + "\n");
            String status = candidate.getStatus();
            if (status != null) {
                sb.append("\t" + status + "\n");
            }
            if (candidate.getStatusCode() != OpCandidate.StatusCode.DOES_NOT_CONFORM) continue;
        }
        return sb.toString();
    }

    private static boolean typeCheckingIncomplete(List<OpCandidate> matches) {
        Type outputType = null;
        for (OpCandidate match : matches) {
            Type ts = match.opInfo().outputType();
            if (outputType == null || Objects.equals(outputType, ts)) {
                outputType = ts;
                continue;
            }
            return true;
        }
        return false;
    }
}

