/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.util;

import com.google.common.collect.Streams;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.scijava.function.Computers;

public final class Maps {
    private Maps() {
    }

    public static interface ComputerMaps {

        public static interface Iterables {
            public static <I, O> Computers.Arity1<Iterable<I>, Iterable<O>> liftBoth(Computers.Arity1<I, O> computer) {
                return (iter1, iter2) -> {
                    Iterator i1 = iter1.iterator();
                    Iterator i2 = iter2.iterator();
                    while (i1.hasNext() && i2.hasNext()) {
                        computer.compute(i1.next(), i2.next());
                    }
                };
            }
        }
    }

    public static interface FunctionMaps {

        public static interface Lists {
            public static <I, O> Function<List<I>, List<O>> liftBoth(Function<I, O> function) {
                return iter -> iter.stream().map(function).collect(Collectors.toList());
            }
        }

        public static interface Arrays {
            public static <I, O> Function<I[], O[]> liftBoth(Function<I, O> function, Class<O> cls) {
                return is -> java.util.Arrays.stream(is).map(function).toArray(size -> (Object[])Array.newInstance(cls, size));
            }
        }

        public static interface Iterables {
            public static <I, O> Function<Iterable<I>, Iterable<O>> liftBoth(Function<I, O> function) {
                return iter -> Streams.stream((Iterable)iter).map(function).collect(Collectors.toList());
            }

            public static <I, O> Function<Iterable<I>, Iterable<O>> bothFlat(Function<I, Iterable<O>> function) {
                return iter -> Streams.stream((Iterable)iter).flatMap(i -> Streams.stream((Iterable)((Iterable)function.apply(i)))).collect(Collectors.toList());
            }
        }
    }
}

