/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc.kendallTau;

import java.util.Arrays;
import java.util.function.BiFunction;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.IterablePair;
import net.imglib2.util.Pair;
import org.scijava.ops.image.coloc.ColocUtil;
import org.scijava.ops.image.coloc.IntArraySorter;
import org.scijava.ops.image.coloc.IntComparator;

public class KendallTauBRank<T extends RealType<T>, U extends RealType<U>>
implements BiFunction<Iterable<T>, Iterable<U>, Double> {
    @Override
    public Double apply(Iterable<T> image1, Iterable<U> image2) {
        if (!ColocUtil.sameIterationOrder(image1, image2)) {
            throw new IllegalArgumentException("Input and output must be of the same iteration order!");
        }
        IterablePair samples = new IterablePair(image1, image2);
        return this.calculateMergeSort((Iterable<Pair<T, U>>)samples);
    }

    private double[][] getPairs(Iterable<Pair<T, U>> samples) {
        int capacity = 0;
        for (Pair<T, U> sample : samples) {
            ++capacity;
        }
        double[] values1 = new double[capacity];
        double[] values2 = new double[capacity];
        int count = 0;
        for (Pair<T, U> sample : samples) {
            values1[count] = ((RealType)sample.getA()).getRealDouble();
            values2[count] = ((RealType)sample.getB()).getRealDouble();
            ++count;
        }
        if (count < capacity) {
            values1 = Arrays.copyOf(values1, count);
            values2 = Arrays.copyOf(values2, count);
        }
        return new double[][]{values1, values2};
    }

    private double calculateMergeSort(Iterable<Pair<T, U>> samples) {
        double[][] pairs = this.getPairs(samples);
        double[] x = pairs[0];
        double[] y = pairs[1];
        int n = x.length;
        int[] index = new int[n];
        for (int i = 0; i < n; ++i) {
            index[i] = i;
        }
        IntArraySorter.sort(index, (a, b) -> {
            double xa = x[a];
            double ya = y[a];
            double xb = x[b];
            double yb = y[b];
            int result = Double.compare(xa, xb);
            return result != 0 ? result : Double.compare(ya, yb);
        });
        long n0 = (long)n * (long)(n - 1) / 2L;
        long n1 = 0L;
        long n3 = 0L;
        for (int i = 1; i < n; ++i) {
            double x0 = x[index[i - 1]];
            if (x[index[i]] != x0) continue;
            double y0 = y[index[i - 1]];
            int i1 = i;
            do {
                double y1;
                if ((y1 = y[index[i1++]]) == y0) {
                    int i2 = i1;
                    while (i1 < n && x[index[i1]] == x0 && y[index[i1]] == y0) {
                        ++i1;
                    }
                    n3 += (long)(i1 - i2 + 2) * (long)(i1 - i2 + 1) / 2L;
                }
                y0 = y1;
            } while (i1 < n && x[index[i1]] == x0);
            n1 += (long)(i1 - i + 1) * (long)(i1 - i) / 2L;
            i = i1;
        }
        MergeSort mergeSort = new MergeSort(index, (a, b) -> {
            double ya = y[a];
            double yb = y[b];
            return Double.compare(ya, yb);
        });
        long S = mergeSort.sort();
        index = mergeSort.getSorted();
        long n2 = 0L;
        for (int i = 1; i < n; ++i) {
            int i1;
            double y0 = y[index[i - 1]];
            if (y[index[i]] != y0) continue;
            for (i1 = i + 1; i1 < n && y[index[i1]] == y0; ++i1) {
            }
            n2 += (long)(i1 - i + 1) * (long)(i1 - i) / 2L;
            i = i1;
        }
        return (double)(n0 - n1 - n2 + n3 - 2L * S) / Math.sqrt((double)(n0 - n1) * (double)(n0 - n2));
    }

    private static final class MergeSort {
        private int[] index;
        private final IntComparator comparator;

        public MergeSort(int[] index, IntComparator comparator) {
            this.index = index;
            this.comparator = comparator;
        }

        public int[] getSorted() {
            return this.index;
        }

        public long sort() {
            long swaps = 0L;
            int n = this.index.length;
            int[] index2 = new int[n];
            for (int step = 1; step < n; step <<= 1) {
                int begin = 0;
                int k = 0;
                while (true) {
                    int begin2;
                    int end;
                    if ((end = (begin2 = begin + step) + step) >= n) {
                        if (begin2 >= n) break;
                        end = n;
                    }
                    int i = begin;
                    int j = begin2;
                    while (i < begin2 && j < end) {
                        int compare = this.comparator.compare(this.index[i], this.index[j]);
                        if (compare > 0) {
                            swaps += (long)(begin2 - i);
                            index2[k++] = this.index[j++];
                            continue;
                        }
                        index2[k++] = this.index[i++];
                    }
                    if (i < begin2) {
                        do {
                            index2[k++] = this.index[i++];
                        } while (i < begin2);
                    } else {
                        while (j < end) {
                            index2[k++] = this.index[j++];
                        }
                    }
                    begin = end;
                }
                if (k < n) {
                    System.arraycopy(this.index, k, index2, k, n - k);
                }
                int[] swapIndex = index2;
                index2 = this.index;
                this.index = swapIndex;
            }
            return swaps;
        }
    }
}

