/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc.saca;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Intervals;
import org.scijava.function.Computers;
import org.scijava.function.Functions;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class SACASigMask
implements Computers.Arity6<RandomAccessibleInterval<DoubleType>, Double, Double, Double, Boolean, Boolean, RandomAccessibleInterval<BitType>> {
    @OpDependency(name="threshold.apply")
    private Computers.Arity2<RandomAccessibleInterval<DoubleType>, DoubleType, RandomAccessibleInterval<BitType>> thresOp;
    @OpDependency(name="stats.qnorm")
    private Functions.Arity5<Double, Double, Double, Boolean, Boolean, Double> qnormOp;

    public void compute(RandomAccessibleInterval<DoubleType> heatmap, @Nullable Double alpha, @Nullable Double mean, @Nullable Double sd, @Nullable Boolean lowerTail, @Nullable Boolean logP, RandomAccessibleInterval<BitType> result) {
        if (alpha == null) {
            alpha = 0.05;
        }
        if (mean == null) {
            mean = 0.0;
        }
        if (sd == null) {
            sd = 1.0;
        }
        if (lowerTail == null) {
            lowerTail = false;
        }
        if (logP == null) {
            logP = false;
        }
        double thres = (Double)this.qnormOp.apply((Object)(alpha / (double)Intervals.numElements(heatmap)), (Object)mean, (Object)sd, (Object)lowerTail, (Object)logP);
        this.thresOp.compute(heatmap, (Object)new DoubleType(thres), result);
    }
}

