/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.convert;

import java.util.function.BiFunction;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.Unsigned128BitType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import net.imglib2.type.numeric.integer.Unsigned2BitType;
import net.imglib2.type.numeric.integer.Unsigned4BitType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public final class ConvertImages {
    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<BitType> typeToBit(@OpDependency(name="create.img") BiFunction<Dimensions, BitType, RandomAccessibleInterval<BitType>> creator, @OpDependency(name="convert.bit") Computers.Arity1<C, BitType> converter, RAIC input) {
        RandomAccessibleInterval<BitType> output = creator.apply((Dimensions)input, new BitType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<Unsigned2BitType> typeToUnsigned2Bit(@OpDependency(name="create.img") BiFunction<Dimensions, Unsigned2BitType, RandomAccessibleInterval<Unsigned2BitType>> creator, @OpDependency(name="convert.uint2") Computers.Arity1<C, Unsigned2BitType> converter, RAIC input) {
        RandomAccessibleInterval<Unsigned2BitType> output = creator.apply((Dimensions)input, new Unsigned2BitType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<Unsigned4BitType> typeToUnsigned4Bit(@OpDependency(name="create.img") BiFunction<Dimensions, Unsigned4BitType, RandomAccessibleInterval<Unsigned4BitType>> creator, @OpDependency(name="convert.uint4") Computers.Arity1<C, Unsigned4BitType> converter, RAIC input) {
        RandomAccessibleInterval<Unsigned4BitType> output = creator.apply((Dimensions)input, new Unsigned4BitType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<ByteType> typeToByte(@OpDependency(name="create.img") BiFunction<Dimensions, ByteType, RandomAccessibleInterval<ByteType>> creator, @OpDependency(name="convert.int8") Computers.Arity1<C, ByteType> converter, RAIC input) {
        RandomAccessibleInterval<ByteType> output = creator.apply((Dimensions)input, new ByteType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<UnsignedByteType> typeToUnsignedByte(@OpDependency(name="create.img") BiFunction<Dimensions, UnsignedByteType, RandomAccessibleInterval<UnsignedByteType>> creator, @OpDependency(name="convert.uint8") Computers.Arity1<C, UnsignedByteType> converter, RAIC input) {
        RandomAccessibleInterval<UnsignedByteType> output = creator.apply((Dimensions)input, new UnsignedByteType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<Unsigned12BitType> typeToUnsigned12Bit(@OpDependency(name="create.img") BiFunction<Dimensions, Unsigned12BitType, RandomAccessibleInterval<Unsigned12BitType>> creator, @OpDependency(name="convert.uint12") Computers.Arity1<C, Unsigned12BitType> converter, RAIC input) {
        RandomAccessibleInterval<Unsigned12BitType> output = creator.apply((Dimensions)input, new Unsigned12BitType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<ShortType> typeToShort(@OpDependency(name="create.img") BiFunction<Dimensions, ShortType, RandomAccessibleInterval<ShortType>> creator, @OpDependency(name="convert.int16") Computers.Arity1<C, ShortType> converter, RAIC input) {
        RandomAccessibleInterval<ShortType> output = creator.apply((Dimensions)input, new ShortType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<UnsignedShortType> typeToUnsignedShort(@OpDependency(name="create.img") BiFunction<Dimensions, UnsignedShortType, RandomAccessibleInterval<UnsignedShortType>> creator, @OpDependency(name="convert.uint16") Computers.Arity1<C, UnsignedShortType> converter, RAIC input) {
        RandomAccessibleInterval<UnsignedShortType> output = creator.apply((Dimensions)input, new UnsignedShortType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<IntType> typeToInt(@OpDependency(name="create.img") BiFunction<Dimensions, IntType, RandomAccessibleInterval<IntType>> creator, @OpDependency(name="convert.int32") Computers.Arity1<C, IntType> converter, RAIC input) {
        RandomAccessibleInterval<IntType> output = creator.apply((Dimensions)input, new IntType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<UnsignedIntType> typeToUnsignedInt(@OpDependency(name="create.img") BiFunction<Dimensions, UnsignedIntType, RandomAccessibleInterval<UnsignedIntType>> creator, @OpDependency(name="convert.uint32") Computers.Arity1<C, UnsignedIntType> converter, RAIC input) {
        RandomAccessibleInterval<UnsignedIntType> output = creator.apply((Dimensions)input, new UnsignedIntType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<LongType> typeToLong(@OpDependency(name="create.img") BiFunction<Dimensions, LongType, RandomAccessibleInterval<LongType>> creator, @OpDependency(name="convert.int64") Computers.Arity1<C, LongType> converter, RAIC input) {
        RandomAccessibleInterval<LongType> output = creator.apply((Dimensions)input, new LongType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<UnsignedLongType> typeToUnsignedLong(@OpDependency(name="create.img") BiFunction<Dimensions, UnsignedLongType, RandomAccessibleInterval<UnsignedLongType>> creator, @OpDependency(name="convert.uint64") Computers.Arity1<C, UnsignedLongType> converter, RAIC input) {
        RandomAccessibleInterval<UnsignedLongType> output = creator.apply((Dimensions)input, new UnsignedLongType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<Unsigned128BitType> typeToUnsigned128Bit(@OpDependency(name="create.img") BiFunction<Dimensions, Unsigned128BitType, RandomAccessibleInterval<Unsigned128BitType>> creator, @OpDependency(name="convert.uint128") Computers.Arity1<C, Unsigned128BitType> converter, RAIC input) {
        RandomAccessibleInterval<Unsigned128BitType> output = creator.apply((Dimensions)input, new Unsigned128BitType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<FloatType> typeToFloat32(@OpDependency(name="create.img") BiFunction<Dimensions, FloatType, RandomAccessibleInterval<FloatType>> creator, @OpDependency(name="convert.float32") Computers.Arity1<C, FloatType> converter, RAIC input) {
        RandomAccessibleInterval<FloatType> output = creator.apply((Dimensions)input, new FloatType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<ComplexFloatType> typeToComplexFloat32(@OpDependency(name="create.img") BiFunction<Dimensions, ComplexFloatType, RandomAccessibleInterval<ComplexFloatType>> creator, @OpDependency(name="convert.cfloat32") Computers.Arity1<C, ComplexFloatType> converter, RAIC input) {
        RandomAccessibleInterval<ComplexFloatType> output = creator.apply((Dimensions)input, new ComplexFloatType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<DoubleType> typeToDouble32(@OpDependency(name="create.img") BiFunction<Dimensions, DoubleType, RandomAccessibleInterval<DoubleType>> creator, @OpDependency(name="convert.float64") Computers.Arity1<C, DoubleType> converter, RAIC input) {
        RandomAccessibleInterval<DoubleType> output = creator.apply((Dimensions)input, new DoubleType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }

    public static <C extends ComplexType<C>, RAIC extends RandomAccessibleInterval<C>> RandomAccessibleInterval<ComplexDoubleType> typeToComplexDouble32(@OpDependency(name="create.img") BiFunction<Dimensions, ComplexDoubleType, RandomAccessibleInterval<ComplexDoubleType>> creator, @OpDependency(name="convert.cfloat64") Computers.Arity1<C, ComplexDoubleType> converter, RAIC input) {
        RandomAccessibleInterval<ComplexDoubleType> output = creator.apply((Dimensions)input, new ComplexDoubleType());
        LoopBuilder.setImages(input, output).forEachPixel(converter);
        return output;
    }
}

