/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.copy;

import java.lang.reflect.Array;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingMapping;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public final class Copiers {
    private Copiers() {
    }

    public static <T extends Type<T>> void copyType(T input, T output) {
        output.set(input);
    }

    public static <T> void copyRAI(@OpDependency(name="copy.type") Computers.Arity1<T, T> copier, RandomAccessibleInterval<T> input, RandomAccessibleInterval<T> copy) {
        Copiers.ensureEqualDimensions(input, copy);
        LoopBuilder.setImages(input, copy).multiThreaded().forEachPixel((arg_0, arg_1) -> copier.compute(arg_0, arg_1));
    }

    public static <T extends IntegerType<T> & NativeType<T>, L> void copyImgLabeling(@OpDependency(name="copy.img") Computers.Arity1<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> raiCopier, @OpDependency(name="copy.labelingMapping") Computers.Arity1<LabelingMapping<L>, LabelingMapping<L>> mappingCopier, ImgLabeling<L, T> input, ImgLabeling<L, T> output) {
        Copiers.ensureEqualDimensions(input, output);
        if (((IntegerType)Util.getTypeFromInterval((Interval)input.getIndexImg())).getClass() != ((IntegerType)Util.getTypeFromInterval((Interval)output.getIndexImg())).getClass()) {
            throw new IllegalArgumentException("input and output index images must be of the same type!");
        }
        raiCopier.compute((Object)input.getIndexImg(), (Object)output.getIndexImg());
        mappingCopier.compute((Object)input.getMapping(), (Object)output.getMapping());
    }

    public static <L> void copyLabelingMapping(LabelingMapping<L> input, LabelingMapping<L> output) {
        output.setLabelSets(input.getLabelSets());
    }

    public static <T extends NativeType<T>, A extends ArrayDataAccess<A>> void copyArrayImage(ArrayImg<T, A> input, ArrayImg<T, A> output) {
        Copiers.ensureEqualDimensions(input, output);
        Object inArray = ((ArrayDataAccess)input.update(null)).getCurrentStorageArray();
        Object outArray = ((ArrayDataAccess)output.update(null)).getCurrentStorageArray();
        System.arraycopy(inArray, 0, outArray, 0, Array.getLength(inArray));
    }

    public static <T> void copyIterableInterval(@OpDependency(name="copy.type") Computers.Arity1<Iterable<T>, Iterable<T>> copier, IterableInterval<T> input, IterableInterval<T> output) {
        if (!input.iterationOrder().equals(output.iterationOrder())) {
            throw new IllegalArgumentException("input and output must be of the same dimensions!");
        }
        copier.compute(input, output);
    }

    private static void ensureEqualDimensions(Dimensions d1, Dimensions d2) {
        if (!Intervals.equalDimensions((Dimensions)d1, (Dimensions)d2)) {
            throw new IllegalArgumentException("The Dimensions of the input and copy images must be the same!");
        }
    }
}

