/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.create;

import java.util.function.BiFunction;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.view.Views;

public final class DefaultCreateKernelBiGauss {
    private DefaultCreateKernelBiGauss() {
    }

    public static <T extends Type<T>, C extends ComplexType<C>> RandomAccessibleInterval<C> createKernel(double[] sigmas, Integer dimensionality, C typeVar, BiFunction<Dimensions, T, Img<T>> createImgFunc) {
        if (sigmas.length < 2) {
            throw new IllegalArgumentException("Two sigmas (for inner and outer Gauss) must be supplied.");
        }
        if (sigmas[0] <= 0.0 || sigmas[1] <= 0.0) {
            throw new IllegalArgumentException("Input sigmas must be both positive.");
        }
        if (dimensionality <= 0) {
            throw new IllegalArgumentException("Input dimensionality must both positive.");
        }
        long[] dims = new long[dimensionality.intValue()];
        long[] centre = new long[dimensionality.intValue()];
        dims[0] = Math.max(3, 2 * (int)(sigmas[0] + 2.0 * sigmas[1] + 0.5) + 1);
        centre[0] = (int)(dims[0] / 2L);
        for (int d = 1; d < dims.length; ++d) {
            dims[d] = dims[0];
            centre[d] = centre[0];
        }
        double k = sigmas[1] / sigmas[0] * (sigmas[1] / sigmas[0]);
        double c0 = 0.24197 * (sigmas[1] / sigmas[0] - 1.0) / sigmas[0];
        double[] C = new double[]{1.0 / (2.50663 * sigmas[0]), 1.0 / (2.50663 * sigmas[1])};
        double[] sigmasSq = new double[]{sigmas[0] * sigmas[0], sigmas[1] * sigmas[1]};
        RandomAccessibleInterval out = (RandomAccessibleInterval)createImgFunc.apply((Dimensions)new FinalInterval(dims), (Dimensions)typeVar);
        Cursor cursor = Views.iterable((RandomAccessibleInterval)out).cursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(dims);
            double dist = 0.0;
            for (int d = 0; d < dims.length; ++d) {
                double dx = dims[d] - centre[d];
                dist += dx * dx;
            }
            double val = 0.0;
            if (dist < sigmasSq[0]) {
                val = C[0] * Math.exp(-0.5 * dist / sigmasSq[0]) + c0;
            } else {
                dist = Math.sqrt(dist) - (sigmas[0] - sigmas[1]);
                dist *= dist;
                val = k * C[1] * Math.exp(-0.5 * dist / sigmasSq[1]);
            }
            ((ComplexType)cursor.get()).setReal(val);
        }
        return out;
    }
}

