/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.create;

import java.util.function.BiFunction;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public final class DefaultCreateKernelGabor {
    private DefaultCreateKernelGabor() {
    }

    public static <T extends Type<T>, C extends ComplexType<C>> RandomAccessibleInterval<C> createKernel(double[] sigmas, double[] period, C typeVar, BiFunction<Dimensions, T, Img<T>> createImgFunc) {
        if (sigmas.length != period.length) {
            throw new IllegalArgumentException("Params length mismatch: The number of sigmas must match the dimensionality of the period vector.");
        }
        for (double s : sigmas) {
            if (!(s < 0.0)) continue;
            throw new IllegalArgumentException("Input sigma must be non-negative.");
        }
        long[] dims = new long[sigmas.length];
        long[] centre = new long[sigmas.length];
        for (int d = 0; d < dims.length; ++d) {
            dims[d] = Math.max(3, 2 * (int)(3.0 * sigmas[d] + 0.5) + 1);
            centre[d] = (int)(dims[d] / 2L);
        }
        RandomAccessibleInterval out = (RandomAccessibleInterval)createImgFunc.apply((Dimensions)new FinalInterval(dims), (Dimensions)typeVar);
        double perLengthSq = 0.0;
        for (int d = 0; d < period.length; ++d) {
            perLengthSq += period[d] * period[d];
        }
        Cursor cursor = Views.iterable((RandomAccessibleInterval)out).cursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(dims);
            double GaussExp = 0.0;
            double freqPart = 0.0;
            double blockingExp = 1.0;
            for (int d = 0; d < dims.length; ++d) {
                double dx = dims[d] - centre[d];
                if (sigmas[d] > 0.0) {
                    GaussExp += dx * dx / (sigmas[d] * sigmas[d]);
                } else if (dx != 0.0) {
                    blockingExp = 0.0;
                }
                freqPart += dx * period[d];
            }
            GaussExp = Math.exp(-0.5 * GaussExp) * blockingExp;
            freqPart = 6.28318 * freqPart / perLengthSq;
            ((ComplexType)cursor.get()).setReal(GaussExp * Math.cos(freqPart));
            if (typeVar instanceof RealType) continue;
            ((ComplexType)cursor.get()).setImaginary(GaussExp * Math.sin(freqPart));
        }
        return out;
    }
}

