/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.create;

import java.util.function.BiFunction;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.commons.math3.special.BesselJ;

public final class DefaultCreateKernelGibsonLanni {
    private DefaultCreateKernelGibsonLanni() {
    }

    public static <T extends Type<T>, C extends ComplexType<C> & NativeType<C>> Img<C> createKernel(Dimensions size, Double NA, Double lambda, Double ns, Double ni, Double resLateral, Double resAxial, Double pZ, C type, BiFunction<Dimensions, T, Img<T>> createFunc) {
        int finish;
        int start;
        double ng0 = 1.5;
        double ng = 1.5;
        double ni0 = 1.5;
        double ti0 = 1.5E-4;
        double tg0 = 1.7E-4;
        double tg = 1.7E-4;
        int numBasis = 100;
        int numSamp = 1000;
        int overSampling = 2;
        if (NA == null) {
            NA = 1.4;
        }
        if (lambda == null) {
            lambda = 6.1E-7;
        }
        if (ns == null) {
            ns = 1.33;
        }
        if (ni == null) {
            ni = 1.5;
        }
        if (resLateral == null) {
            resLateral = 1.0E-7;
        }
        if (resAxial == null) {
            resAxial = 2.5E-7;
        }
        if (pZ == null) {
            pZ = 2.0E-6;
        }
        ni0 = ni;
        int nx = -1;
        int ny = -1;
        int nz = -1;
        if (size.numDimensions() == 2) {
            nx = (int)size.dimension(0);
            ny = (int)size.dimension(1);
            nz = 1;
        } else if (size.numDimensions() == 3) {
            nx = (int)size.dimension(0);
            ny = (int)size.dimension(1);
            nz = (int)size.dimension(2);
        }
        int distanceFromCenter = (int)Math.abs(Math.ceil(pZ / resAxial));
        nz += 2 * distanceFromCenter;
        double x0 = (double)(nx - 1) / 2.0;
        double y0 = (double)(ny - 1) / 2.0;
        double xp = x0;
        double yp = y0;
        int maxRadius = (int)Math.round(Math.sqrt(((double)nx - x0) * ((double)nx - x0) + ((double)ny - y0) * ((double)ny - y0))) + 1;
        double[] r = new double[maxRadius * overSampling];
        double[][] h = new double[nz][r.length];
        double a = 0.0;
        double b = Math.min(1.0, ns / NA);
        double k0 = Math.PI * 2 / lambda;
        double factor1 = 5.450000000000001E-7 / lambda;
        double factor = factor1 * NA / 1.4;
        double deltaRho = (b - a) / (double)(numSamp - 1);
        double rho = 0.0;
        double am = 0.0;
        double[][] Basis = new double[numSamp][numBasis];
        BesselJ bj0 = new BesselJ(0.0);
        BesselJ bj1 = new BesselJ(1.0);
        for (int m = 0; m < numBasis; ++m) {
            am = 3 * m + 1;
            for (int rhoi = 0; rhoi < numSamp; ++rhoi) {
                rho = (double)rhoi * deltaRho;
                Basis[rhoi][m] = bj0.value(am * rho);
            }
        }
        double ti = 0.0;
        double OPD = 0.0;
        double W = 0.0;
        double[][] Coef = new double[nz][numBasis * 2];
        double[][] Ffun = new double[numSamp][nz * 2];
        for (int z = 0; z < nz; ++z) {
            ti = ti0 + resAxial * ((double)z - ((double)nz - 1.0) / 2.0);
            for (int rhoi = 0; rhoi < numSamp; ++rhoi) {
                rho = (double)rhoi * deltaRho;
                double rhoNA2 = rho * rho * NA * NA;
                OPD = pZ * Math.sqrt(ns * ns - rhoNA2);
                OPD += tg * Math.sqrt(ng * ng - rhoNA2) - tg0 * Math.sqrt(ng0 * ng0 - rhoNA2);
                W = k0 * (OPD += ti * Math.sqrt(ni * ni - rhoNA2) - ti0 * Math.sqrt(ni0 * ni0 - rhoNA2));
                Ffun[rhoi][z] = Math.cos(W);
                Ffun[rhoi][z + nz] = Math.sin(W);
            }
        }
        Array2DRowRealMatrix coefficients = new Array2DRowRealMatrix(Basis, false);
        Array2DRowRealMatrix rhsFun = new Array2DRowRealMatrix(Ffun, false);
        DecompositionSolver solver = new SingularValueDecomposition((RealMatrix)coefficients).getSolver();
        RealMatrix solution = solver.solve((RealMatrix)rhsFun);
        Coef = solution.getData();
        double[][] RM = new double[numBasis][r.length];
        double beta = 0.0;
        double rm = 0.0;
        for (int n = 0; n < r.length; ++n) {
            r[n] = (double)n * 1.0 / (double)overSampling;
            beta = k0 * NA * r[n] * resLateral;
            for (int m = 0; m < numBasis; ++m) {
                am = 3 * m + 1;
                rm = am * bj1.value(am * b) * bj0.value(beta * b) * b;
                RM[m][n] = (rm -= beta * b * bj0.value(am * b) * bj1.value(beta * b)) / (am * am - beta * beta);
            }
        }
        double maxValue = 0.0;
        for (int z = 0; z < nz; ++z) {
            for (int n = 0; n < r.length; ++n) {
                double realh = 0.0;
                double imgh = 0.0;
                for (int m = 0; m < numBasis; ++m) {
                    realh += RM[m][n] * Coef[m][z];
                    imgh += RM[m][n] * Coef[m][z + nz];
                }
                h[z][n] = realh * realh + imgh * imgh;
            }
        }
        double[][] Pixel = new double[nz][nx * ny];
        for (int z = 0; z < nz; ++z) {
            for (int x = 0; x < nx; ++x) {
                for (int y = 0; y < ny; ++y) {
                    double value;
                    double rPixel = Math.sqrt(((double)x - xp) * ((double)x - xp) + ((double)y - yp) * ((double)y - yp));
                    int index = (int)Math.floor(rPixel * (double)overSampling);
                    Pixel[z][x + nx * y] = value = h[z][index] + (h[z][index + 1] - h[z][index]) * (rPixel - r[index]) * (double)overSampling;
                    if (!(value > maxValue)) continue;
                    maxValue = value;
                }
            }
        }
        Img<T> psf3d = createFunc.apply(size, (Dimensions)type);
        RandomAccess ra = psf3d.randomAccess();
        if (pZ < 0.0) {
            start = 2 * distanceFromCenter;
            finish = nz;
        } else {
            start = 0;
            finish = nz - 2 * distanceFromCenter;
        }
        for (int z = start; z < finish; ++z) {
            for (int x = 0; x < nx; ++x) {
                int y = 0;
                while (y < ny) {
                    double value = Pixel[z][x + nx * y] / maxValue;
                    ra.setPosition(new int[]{x, y++, z - start});
                    ((ComplexType)ra.get()).setReal(value);
                }
            }
        }
        return psf3d;
    }
}

