/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.create;

import java.util.function.BiFunction;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.view.Views;

public final class DefaultCreateKernelLog {
    private DefaultCreateKernelLog() {
    }

    public static <T extends Type<T>, C extends ComplexType<C>> RandomAccessibleInterval<C> createKernel(double[] sigmas, C type, BiFunction<Dimensions, T, Img<T>> imgFromDimsAndType) {
        double[] sigmaPixels = new double[sigmas.length];
        for (int i = 0; i < sigmaPixels.length; ++i) {
            double sigma_optimal;
            sigmaPixels[i] = sigma_optimal = sigmas[i] / Math.sqrt(sigmas.length);
        }
        int n = sigmaPixels.length;
        long[] dims = new long[n];
        long[] middle = new long[n];
        for (int d = 0; d < n; ++d) {
            int hksizes = Math.max(2, (int)(3.0 * sigmaPixels[d] + 0.5) + 1);
            dims[d] = 3 + 2 * hksizes;
            middle[d] = 1 + hksizes;
        }
        RandomAccessibleInterval output = (RandomAccessibleInterval)imgFromDimsAndType.apply((Dimensions)new FinalInterval(dims), (Dimensions)type);
        Cursor c = Views.iterable((RandomAccessibleInterval)output).cursor();
        long[] coords = new long[sigmas.length];
        double C = 0.05 * Math.pow(1.0 / sigmas[0] / Math.sqrt(Math.PI * 2), sigmas.length);
        while (c.hasNext()) {
            c.fwd();
            c.localize(coords);
            double mantissa = 0.0;
            double exponent = 0.0;
            for (int d = 0; d < coords.length; ++d) {
                double x = coords[d] - middle[d];
                mantissa += -C * (x * x / sigmas[0] / sigmas[0] - 1.0);
                exponent += -x * x / 2.0 / sigmas[0] / sigmas[0];
            }
            ((ComplexType)c.get()).setReal(mantissa * Math.exp(exponent));
        }
        return output;
    }
}

