/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.deconvolve;

import java.util.function.BiFunction;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;
import org.scijava.function.Computers;
import org.scijava.function.Functions;
import org.scijava.ops.spi.OpDependency;

public class NonCirculantFirstGuess<I extends RealType<I>, O extends RealType<O>, K extends RealType<K>, C extends ComplexType<C>>
implements Functions.Arity3<RandomAccessibleInterval<I>, O, Dimensions, RandomAccessibleInterval<O>> {
    @OpDependency(name="create.img")
    BiFunction<Dimensions, O, Img<O>> create;
    @OpDependency(name="stats.sum")
    Computers.Arity1<Iterable<I>, DoubleType> sum;

    public RandomAccessibleInterval<O> apply(RandomAccessibleInterval<I> input, O outType, Dimensions k) {
        Img<O> firstGuess = this.create.apply((Dimensions)input, outType);
        DoubleType s = new DoubleType();
        this.sum.compute((Object)Views.iterable(input), (Object)s);
        long numPixels = 1L;
        for (int d = 0; d < k.numDimensions(); ++d) {
            numPixels *= k.dimension(d);
        }
        double average = s.getRealDouble() / (double)numPixels;
        for (RealType type : firstGuess) {
            type.setReal(average);
        }
        return firstGuess;
    }
}

