/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.deconvolve;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Point;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.function.Computers;
import org.scijava.function.Inplaces;
import org.scijava.ops.spi.OpDependency;

public class NonCirculantNormalizationFactor<I extends RealType<I>, O extends RealType<O>, K extends RealType<K>, C extends ComplexType<C>>
implements Inplaces.Arity5_1<RandomAccessibleInterval<O>, Dimensions, Dimensions, RandomAccessibleInterval<C>, RandomAccessibleInterval<C>> {
    private Dimensions k;
    private Dimensions l;
    private RandomAccessibleInterval<C> fftInput;
    private RandomAccessibleInterval<C> fftKernel;
    private Img<O> normalization = null;
    @OpDependency(name="create.img")
    private BiFunction<Dimensions, O, Img<O>> create;
    @OpDependency(name="filter.correlate")
    private Computers.Arity6<RandomAccessibleInterval<O>, RandomAccessibleInterval<K>, RandomAccessibleInterval<C>, RandomAccessibleInterval<C>, Boolean, Boolean, RandomAccessibleInterval<O>> correlater;
    private BiConsumer<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> divide = (numerResult, denom) -> {
        RealType tmp = (RealType)((RealType)Util.getTypeFromInterval((Interval)numerResult)).createVariable();
        LoopBuilder.setImages((RandomAccessibleInterval)numerResult, (RandomAccessibleInterval)denom).forEachPixel((n, d) -> {
            if (n.getRealFloat() > 0.0f) {
                tmp.set((Type)n);
                tmp.div(d);
                n.set((Type)tmp);
            } else {
                n.setZero();
            }
        });
    };

    public void mutate(RandomAccessibleInterval<O> arg, Dimensions k, Dimensions l, RandomAccessibleInterval<C> fftInput, RandomAccessibleInterval<C> fftKernel) {
        this.k = k;
        this.l = l;
        this.fftInput = fftInput;
        this.fftKernel = fftKernel;
        if (this.normalization == null) {
            this.createNormalizationImageSemiNonCirculant((Interval)arg, (O)((RealType)Util.getTypeFromInterval(arg)));
        }
        this.divide.accept(arg, (RandomAccessibleInterval<O>)this.normalization);
    }

    protected void createNormalizationImageSemiNonCirculant(Interval fastFFTInterval, O type) {
        int d;
        int length = this.k.numDimensions();
        long[] n = new long[length];
        long[] nFFT = new long[length];
        for (d = 0; d < length; ++d) {
            n[d] = this.k.dimension(d) + this.l.dimension(d) - 1L;
        }
        for (d = 0; d < length; ++d) {
            nFFT[d] = fastFFTInterval.dimension(d);
        }
        FinalDimensions fd = new FinalDimensions(nFFT);
        this.normalization = this.create.apply((Dimensions)fd, type);
        Point size = new Point(length);
        long[] sizel = new long[length];
        for (int d2 = 0; d2 < length; ++d2) {
            size.setPosition(this.k.dimension(d2), d2);
            sizel[d2] = this.k.dimension(d2);
        }
        Point start = new Point(length);
        long[] startl = new long[length];
        long[] endl = new long[length];
        for (int d3 = 0; d3 < length; ++d3) {
            start.setPosition((nFFT[d3] - this.k.dimension(d3)) / 2L, d3);
            startl[d3] = (nFFT[d3] - this.k.dimension(d3)) / 2L;
            endl[d3] = startl[d3] + sizel[d3] - 1L;
        }
        Point maskSize = new Point(length);
        long[] maskSizel = new long[length];
        for (int d4 = 0; d4 < length; ++d4) {
            maskSize.setPosition(Math.min(n[d4], nFFT[d4]), d4);
            maskSizel[d4] = Math.min(n[d4], nFFT[d4]);
        }
        Point maskStart = new Point(length);
        long[] maskStartl = new long[length];
        for (int d5 = 0; d5 < length; ++d5) {
            maskStart.setPosition(Math.max(0L, nFFT[d5] - n[d5]) / 2L, d5);
            maskStartl[d5] = Math.max(0L, nFFT[d5] - n[d5]) / 2L;
        }
        IntervalView temp = Views.interval(this.normalization, (Interval)new FinalInterval(startl, endl));
        Cursor normCursor = Views.iterable((RandomAccessibleInterval)temp).cursor();
        while (normCursor.hasNext()) {
            normCursor.fwd();
            ((RealType)normCursor.get()).setReal(1.0);
        }
        Img<O> tempImg = this.create.apply((Dimensions)fd, type);
        this.correlater.compute(this.normalization, null, this.fftInput, this.fftKernel, (Object)true, (Object)false, tempImg);
        this.normalization = tempImg;
        Cursor cursorN = this.normalization.cursor();
        while (cursorN.hasNext()) {
            cursorN.fwd();
            if (!(((RealType)cursorN.get()).getRealFloat() <= 0.001f)) continue;
            ((RealType)cursorN.get()).setReal(1.0f);
        }
    }
}

