/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.haralick;

import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ops.image.features.haralick.AbstractHaralickFeature;
import org.scijava.ops.image.image.cooccurrenceMatrix.MatrixOrientation;
import org.scijava.ops.spi.OpDependency;

public class DefaultCorrelation<T extends RealType<T>>
extends AbstractHaralickFeature<T> {
    @OpDependency(name="features.haralick.coocMeanX")
    private Function<double[][], DoubleType> coocMeanXFunc;
    @OpDependency(name="features.haralick.coocMeanY")
    private Function<double[][], DoubleType> coocMeanYFunc;
    @OpDependency(name="features.haralick.coocStdY")
    private Function<double[][], DoubleType> coocStdYFunc;
    @OpDependency(name="features.haralick.coocStdX")
    private Function<double[][], DoubleType> coocStdXFunc;

    public DoubleType apply(RandomAccessibleInterval<T> input, Integer numGreyLevels, Integer distance, MatrixOrientation orientation) {
        double[][] matrix = this.getCooccurrenceMatrix(input, numGreyLevels, distance, orientation);
        int nrGrayLevels = matrix.length;
        double meanx = this.coocMeanXFunc.apply(matrix).get();
        double meany = this.coocMeanYFunc.apply(matrix).get();
        double stdx = this.coocStdXFunc.apply(matrix).get();
        double stdy = this.coocStdYFunc.apply(matrix).get();
        double sum = 0.0;
        for (int i = 0; i < nrGrayLevels; ++i) {
            for (int j = 0; j < nrGrayLevels; ++j) {
                sum += (double)(i * j) * matrix[i][j];
            }
        }
        DoubleType output = new DoubleType();
        output.set((sum - meanx * meany) / (stdx * stdy));
        return output;
    }
}

