/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.haralick;

import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Functions;
import org.scijava.ops.image.features.haralick.AbstractHaralickFeature;
import org.scijava.ops.image.image.cooccurrenceMatrix.MatrixOrientation;
import org.scijava.ops.spi.OpDependency;

public class DefaultICM1<T extends RealType<T>>
extends AbstractHaralickFeature<T> {
    @OpDependency(name="features.haralick.coocHXY")
    private Function<double[][], double[]> coocHXYFunc;
    @OpDependency(name="features.haralick.entropy")
    private Functions.Arity4<RandomAccessibleInterval<T>, Integer, Integer, MatrixOrientation, DoubleType> entropy;

    public DoubleType apply(RandomAccessibleInterval<T> input, Integer numGreyLevels, Integer distance, MatrixOrientation orientation) {
        double[][] matrix = this.getCooccurrenceMatrix(input, numGreyLevels, distance, orientation);
        double[] coochxy = this.coocHXYFunc.apply(matrix);
        double res = (((DoubleType)this.entropy.apply(input, (Object)numGreyLevels, (Object)distance, (Object)orientation)).get() - coochxy[2]) / (coochxy[0] > coochxy[1] ? coochxy[0] : coochxy[1]);
        DoubleType output = new DoubleType();
        output.set(res);
        return output;
    }
}

