/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.haralick;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ops.image.features.haralick.AbstractHaralickFeature;
import org.scijava.ops.image.image.cooccurrenceMatrix.MatrixOrientation;

public class DefaultVariance<T extends RealType<T>>
extends AbstractHaralickFeature<T> {
    public DoubleType apply(RandomAccessibleInterval<T> input, Integer numGreyLevels, Integer distance, MatrixOrientation orientation) {
        double[][] matrix = this.getCooccurrenceMatrix(input, numGreyLevels, distance, orientation);
        int nrGreyLevel = matrix.length;
        double mean = 0.0;
        for (int i = 0; i < nrGreyLevel; ++i) {
            for (int j = 0; j < nrGreyLevel; ++j) {
                mean += matrix[i][j];
            }
        }
        mean /= (double)(nrGreyLevel * nrGreyLevel);
        double result = 0.0;
        for (int i = 0; i < nrGreyLevel; ++i) {
            for (int j = 0; j < nrGreyLevel; ++j) {
                result += ((double)i - mean) * ((double)i - mean) * matrix[i][j];
            }
        }
        DoubleType output = new DoubleType();
        output.set(result);
        return output;
    }
}

