/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.haralick.helper;

import java.util.function.Function;
import org.scijava.ops.spi.OpDependency;

public class CoocHXY
implements Function<double[][], double[]> {
    private static final double EPSILON = Double.MIN_NORMAL;
    @OpDependency(name="features.haralick.coocPX")
    private Function<double[][], double[]> coocPXFunc;
    @OpDependency(name="features.haralick.coocPY")
    private Function<double[][], double[]> coocPYFunc;

    @Override
    public double[] apply(double[][] matrix) {
        int i;
        double hx = 0.0;
        double hy = 0.0;
        double hxy1 = 0.0;
        double hxy2 = 0.0;
        int nrGrayLevels = matrix.length;
        double[] px = this.coocPXFunc.apply(matrix);
        double[] py = this.coocPYFunc.apply(matrix);
        for (i = 0; i < px.length; ++i) {
            hx += px[i] * Math.log(px[i] + Double.MIN_NORMAL);
        }
        hx = -hx;
        for (int j = 0; j < py.length; ++j) {
            hy += py[j] * Math.log(py[j] + Double.MIN_NORMAL);
        }
        hy = -hy;
        for (i = 0; i < nrGrayLevels; ++i) {
            for (int j = 0; j < nrGrayLevels; ++j) {
                hxy1 += matrix[i][j] * Math.log(px[i] * py[j] + Double.MIN_NORMAL);
                hxy2 += px[i] * py[j] * Math.log(px[i] * py[j] + Double.MIN_NORMAL);
            }
        }
        hxy1 = -hxy1;
        hxy2 = -hxy2;
        return new double[]{hx, hy, hxy1, hxy2};
    }
}

