/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.tamura2d;

import java.util.ArrayList;
import java.util.HashMap;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Intervals;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class DefaultCoarsenessFeature<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity1<RandomAccessibleInterval<I>, O> {
    @OpDependency(name="filter.mean")
    private Computers.Arity3<RandomAccessibleInterval<I>, Shape, OutOfBoundsFactory<I, RandomAccessibleInterval<I>>, RandomAccessibleInterval<I>> meanOp;

    public void compute(RandomAccessibleInterval<I> input, O output) {
        if (input.numDimensions() != 2) {
            throw new IllegalArgumentException("Only 2 dimensional images allowed!");
        }
        HashMap<Integer, Img<I>> meanImages = new HashMap<Integer, Img<I>>();
        for (int i = 1; i <= 5; ++i) {
            meanImages.put(i, this.mean(input, i));
        }
        ArrayList<Double> maxDifferences = this.sizedLeadDiffValues(input, meanImages);
        double out = 0.0;
        for (Double i : maxDifferences) {
            out += i.doubleValue();
        }
        output.set((Type)new DoubleType(out /= (double)maxDifferences.size()));
    }

    private ArrayList<Double> sizedLeadDiffValues(RandomAccessibleInterval<I> input, HashMap<Integer, Img<I>> meanImages) {
        long[] pos = new long[input.numDimensions()];
        long[] dim = new long[input.numDimensions()];
        input.dimensions(dim);
        ArrayList<Double> maxDifferences = new ArrayList<Double>();
        Cursor cursor = meanImages.get(1).cursor();
        while (cursor.hasNext()) {
            cursor.next();
            double maxDiff = 0.0;
            for (int i = 1; i <= 5; ++i) {
                RandomAccess ra1 = meanImages.get(i).randomAccess();
                RandomAccess ra2 = meanImages.get(i).randomAccess();
                for (int d = 0; d < input.numDimensions(); ++d) {
                    cursor.localize(pos);
                    if (pos[d] + (long)(2 * i) + 1L >= dim[d]) continue;
                    ra1.setPosition(pos);
                    double val1 = ((RealType)ra1.get()).getRealDouble();
                    int n = d;
                    pos[n] = pos[n] + (long)(2 * i + 1);
                    ra2.setPosition(pos);
                    double val2 = ((RealType)ra2.get()).getRealDouble();
                    double diff = Math.abs(val2 - val1);
                    maxDiff = diff >= maxDiff ? diff : maxDiff;
                }
            }
            maxDifferences.add(maxDiff);
        }
        return maxDifferences;
    }

    private Img<I> mean(RandomAccessibleInterval<I> input, int i) {
        long[] dims = new long[input.numDimensions()];
        input.dimensions(dims);
        byte[] array = new byte[(int)Intervals.numElements((Dimensions)new FinalInterval(dims))];
        ArrayImg meanImg = ArrayImgs.unsignedBytes((byte[])array, (long[])dims);
        OutOfBoundsMirrorFactory oobFactory = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
        this.meanOp.compute(input, (Object)new RectangleShape(i, true), (Object)oobFactory, (Object)meanImg);
        return meanImg;
    }
}

