/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.derivative;

import java.util.function.Function;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class PartialDerivativeRAI<T extends RealType<T>>
implements Computers.Arity2<RandomAccessibleInterval<T>, Integer, RandomAccessibleInterval<T>> {
    @OpDependency(name="create.img")
    private Function<RandomAccessibleInterval<T>, Img<T>> createRAI;
    @OpDependency(name="create.img")
    private Function<long[], Img<DoubleType>> createImg;
    @OpDependency(name="math.add")
    private Computers.Arity2<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> addOp;
    @OpDependency(name="filter.convolve")
    private Computers.Arity2<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> convolveOp;
    private Computers.Arity1<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> kernelBConvolveOp;
    private Computers.Arity1<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>>[] kernelAConvolveOps;
    @OpDependency(name="create.kernelSobel")
    private Function<T, RandomAccessibleInterval<T>> sobelKernelCreator;

    public void setupConvolves(RandomAccessibleInterval<T> input, Integer dimension) {
        Img<DoubleType> kernelInterval;
        RandomAccessibleInterval<T> kernel = this.sobelKernelCreator.apply((RealType)Util.getTypeFromInterval(input));
        IntervalView kernelA = Views.hyperSlice((RandomAccessibleInterval)Views.hyperSlice(kernel, (int)3, (long)0L), (int)2, (long)0L);
        IntervalView kernelB = Views.hyperSlice((RandomAccessibleInterval)Views.hyperSlice(kernel, (int)3, (long)0L), (int)2, (long)1L);
        if (input.numDimensions() > 2) {
            MixedTransformView expandedKernelA = Views.addDimension((RandomAccessible)kernelA);
            MixedTransformView expandedKernelB = Views.addDimension((RandomAccessible)kernelB);
            for (int i = 0; i < input.numDimensions() - 3; ++i) {
                expandedKernelA = Views.addDimension((RandomAccessible)expandedKernelA);
                expandedKernelB = Views.addDimension((RandomAccessible)expandedKernelB);
            }
            long[] dims = new long[input.numDimensions()];
            for (int j = 0; j < input.numDimensions(); ++j) {
                dims[j] = 1L;
            }
            dims[0] = 3L;
            kernelInterval = new Img<DoubleType>(dims);
            kernelA = Views.interval((RandomAccessible)expandedKernelA, (Interval)kernelInterval);
            kernelB = Views.interval((RandomAccessible)expandedKernelB, (Interval)kernelInterval);
        }
        long[] dims = new long[input.numDimensions()];
        if (dimension == 0) {
            IntervalView finalKernelB = kernelB;
            this.kernelBConvolveOp = (arg_0, arg_1) -> this.lambda$setupConvolves$0((RandomAccessibleInterval)finalKernelB, arg_0, arg_1);
        } else {
            for (int j = 0; j < input.numDimensions(); ++j) {
                dims[j] = j == dimension ? 3L : 1L;
            }
            Img<DoubleType> kernelInterval2 = this.createImg.apply(dims);
            IntervalView rotatedKernelB = kernelB;
            for (int i = 0; i < dimension; ++i) {
                rotatedKernelB = Views.rotate((RandomAccessibleInterval)rotatedKernelB, (int)i, (int)(i + 1));
            }
            IntervalView finalRotatedKernelB = Views.interval((RandomAccessible)rotatedKernelB, kernelInterval2);
            this.kernelBConvolveOp = (arg_0, arg_1) -> this.lambda$setupConvolves$1((RandomAccessibleInterval)finalRotatedKernelB, arg_0, arg_1);
        }
        dims = null;
        this.kernelAConvolveOps = new Computers.Arity1[input.numDimensions()];
        if (dimension != 0) {
            IntervalView finalKernelA = kernelA;
            this.kernelAConvolveOps[0] = (arg_0, arg_1) -> this.lambda$setupConvolves$2((RandomAccessibleInterval)finalKernelA, arg_0, arg_1);
        }
        IntervalView rotatedKernelA = kernelA;
        for (int i = 1; i < input.numDimensions(); ++i) {
            if (i == dimension) continue;
            dims = new long[input.numDimensions()];
            for (int j = 0; j < input.numDimensions(); ++j) {
                dims[j] = i == j ? 3L : 1L;
            }
            kernelInterval = this.createImg.apply(dims);
            for (int j = 0; j < i; ++j) {
                rotatedKernelA = Views.rotate((RandomAccessibleInterval)rotatedKernelA, (int)j, (int)(j + 1));
            }
            IntervalView finalRotatedKernelA = rotatedKernelA;
            this.kernelAConvolveOps[i] = (arg_0, arg_1) -> this.lambda$setupConvolves$3((RandomAccessibleInterval)finalRotatedKernelA, kernelInterval, arg_0, arg_1);
            rotatedKernelA = kernelA;
        }
    }

    public void compute(RandomAccessibleInterval<T> input, Integer dimension, RandomAccessibleInterval<T> output) {
        this.setupConvolves(input, dimension);
        RandomAccessibleInterval in = input;
        for (int i = input.numDimensions() - 1; i >= 0; --i) {
            RandomAccessibleInterval derivative = (RandomAccessibleInterval)this.createRAI.apply(input);
            if (dimension == i) {
                this.kernelBConvolveOp.compute((Object)Views.interval((RandomAccessible)Views.extendMirrorDouble(in), input), (Object)derivative);
            } else {
                this.kernelAConvolveOps[i].compute((Object)Views.interval((RandomAccessible)Views.extendMirrorDouble(in), input), (Object)derivative);
            }
            in = derivative;
        }
        this.addOp.compute(output, in, output);
    }

    private /* synthetic */ void lambda$setupConvolves$3(RandomAccessibleInterval finalRotatedKernelA, Img kernelInterval, RandomAccessibleInterval in, RandomAccessibleInterval out) {
        this.convolveOp.compute((Object)in, (Object)Views.interval((RandomAccessible)finalRotatedKernelA, (Interval)kernelInterval), (Object)out);
    }

    private /* synthetic */ void lambda$setupConvolves$2(RandomAccessibleInterval finalKernelA, RandomAccessibleInterval in, RandomAccessibleInterval out) {
        this.convolveOp.compute((Object)in, (Object)finalKernelA, (Object)out);
    }

    private /* synthetic */ void lambda$setupConvolves$1(RandomAccessibleInterval finalRotatedKernelB, RandomAccessibleInterval in, RandomAccessibleInterval out) {
        this.convolveOp.compute((Object)in, (Object)finalRotatedKernelB, (Object)out);
    }

    private /* synthetic */ void lambda$setupConvolves$0(RandomAccessibleInterval finalKernelB, RandomAccessibleInterval in, RandomAccessibleInterval out) {
        this.convolveOp.compute((Object)in, (Object)finalKernelB, (Object)out);
    }
}

