/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.gauss;

import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.algorithm.gauss3.SeparableSymmetricConvolution;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import org.scijava.concurrent.Parallelization;
import org.scijava.ops.spi.Nullable;

public final class Gaussians {
    private Gaussians() {
    }

    public static <I extends NumericType<I>, O extends NumericType<O>> void defaultGaussRAI(RandomAccessibleInterval<I> input, double[] sigmas, @Nullable OutOfBoundsFactory<I, RandomAccessibleInterval<I>> outOfBounds, RandomAccessibleInterval<O> output) {
        if (outOfBounds == null) {
            outOfBounds = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
        }
        ExtendedRandomAccessibleInterval eIn = Views.extend(input, outOfBounds);
        try {
            SeparableSymmetricConvolution.convolve((double[][])Gauss3.halfkernels((double[])sigmas), (RandomAccessible)eIn, output, (ExecutorService)Parallelization.getExecutorService());
        }
        catch (IncompatibleTypeException e) {
            throw new RuntimeException(e);
        }
    }

    public static <I extends NumericType<I>, O extends NumericType<O>> void gaussRAISingleSigma(RandomAccessibleInterval<I> input, double sigma, @Nullable OutOfBoundsFactory<I, RandomAccessibleInterval<I>> outOfBounds, RandomAccessibleInterval<O> output) {
        double[] sigmas = new double[input.numDimensions()];
        Arrays.fill(sigmas, sigma);
        Gaussians.defaultGaussRAI(input, sigmas, outOfBounds, output);
    }
}

