/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.hessian;

import java.util.ArrayList;
import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.RealComposite;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class HessianRAI<T extends RealType<T>>
implements Function<RandomAccessibleInterval<T>, CompositeIntervalView<T, RealComposite<T>>> {
    @OpDependency(name="filter.partialDerivative")
    private Computers.Arity2<RandomAccessibleInterval<T>, Integer, RandomAccessibleInterval<T>> derivativeComputer;
    @OpDependency(name="create.img")
    private Function<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> createRAI;

    @Override
    public CompositeIntervalView<T, RealComposite<T>> apply(RandomAccessibleInterval<T> input) {
        ArrayList<RandomAccessibleInterval<T>> derivatives = new ArrayList<RandomAccessibleInterval<T>>();
        for (int i = 0; i < input.numDimensions(); ++i) {
            RandomAccessibleInterval<T> derivative = this.createRAI.apply(input);
            this.derivativeComputer.compute(input, (Object)i, derivative);
            for (int j = 0; j < input.numDimensions(); ++j) {
                RandomAccessibleInterval<T> out = this.createRAI.apply(input);
                this.derivativeComputer.compute(derivative, (Object)j, out);
                derivatives.add(out);
            }
        }
        RandomAccessibleInterval stackedDerivatives = Views.stack(derivatives);
        return Views.collapseReal((RandomAccessibleInterval)stackedDerivatives);
    }
}

