/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.ifft;

import java.util.function.Function;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.fft2.FFTMethods;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class IFFTMethodsOpC<C extends ComplexType<C>, T extends RealType<T>>
implements Computers.Arity1<RandomAccessibleInterval<C>, RandomAccessibleInterval<T>> {
    @OpDependency(name="copy.rai")
    private Function<RandomAccessibleInterval<C>, RandomAccessibleInterval<C>> copyOp;

    public void compute(RandomAccessibleInterval<C> input, RandomAccessibleInterval<T> output) {
        if (!this.conforms(input)) {
            throw new IllegalArgumentException("The input image dimensions to not conform to a supported FFT size");
        }
        RandomAccessibleInterval<C> temp = this.copyOp.apply(input);
        for (int d = input.numDimensions() - 1; d > 0; --d) {
            FFTMethods.complexToComplex(temp, (int)d, (boolean)false, (boolean)true);
        }
        FFTMethods.complexToReal(temp, output, (Interval)FFTMethods.unpaddingIntervalCentered(temp, output), (int)0, (boolean)true);
    }

    public boolean conforms(RandomAccessibleInterval<C> input) {
        long[] paddedDimensions = new long[input.numDimensions()];
        long[] realDimensions = new long[input.numDimensions()];
        boolean fastSizeConforms = false;
        FFTMethods.dimensionsComplexToRealFast(input, (long[])paddedDimensions, (long[])realDimensions);
        if (FFTMethods.dimensionsEqual(input, (long[])paddedDimensions)) {
            fastSizeConforms = true;
        }
        boolean smallSizeConforms = false;
        FFTMethods.dimensionsComplexToRealSmall(input, (long[])paddedDimensions, (long[])realDimensions);
        if (FFTMethods.dimensionsEqual(input, (long[])paddedDimensions)) {
            smallSizeConforms = true;
        }
        return fastSizeConforms || smallSizeConforms;
    }
}

