/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.ifft;

import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.fft2.FFTMethods;
import net.imglib2.type.numeric.ComplexType;
import org.scijava.function.Inplaces;

public class IFFTMethodsOpI<C extends ComplexType<C>>
implements Inplaces.Arity1<RandomAccessibleInterval<C>> {
    public void mutate(RandomAccessibleInterval<C> inout) {
        if (!this.conforms(inout)) {
            throw new IllegalArgumentException("The input size does not conform to a supported FFT size!");
        }
        for (int d = inout.numDimensions() - 1; d >= 0; --d) {
            FFTMethods.complexToComplex(inout, (int)d, (boolean)false, (boolean)true);
        }
    }

    public boolean conforms(RandomAccessibleInterval inout) {
        long[] paddedDimensions = new long[inout.numDimensions()];
        boolean fastSizeConforms = false;
        FFTMethods.dimensionsComplexToComplexFast((Dimensions)inout, (long[])paddedDimensions);
        if (FFTMethods.dimensionsEqual((Interval)inout, (long[])paddedDimensions)) {
            fastSizeConforms = true;
        }
        boolean smallSizeConforms = false;
        FFTMethods.dimensionsComplexToComplexSmall((Dimensions)inout, (long[])paddedDimensions);
        if (FFTMethods.dimensionsEqual((Interval)inout, (long[])paddedDimensions)) {
            smallSizeConforms = true;
        }
        return fastSizeConforms || smallSizeConforms;
    }
}

