/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.pad;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.ops.spi.OpDependency;

public class PadShiftKernel<T extends ComplexType<T>, I extends RandomAccessibleInterval<T>, O extends RandomAccessibleInterval<T>>
implements BiFunction<I, Dimensions, O> {
    @OpDependency(name="filter.padIntervalCentered")
    private BiFunction<I, Dimensions, Interval> paddingIntervalCentered;
    @OpDependency(name="filter.padIntervalOrigin")
    private BiFunction<I, Interval, Interval> paddingIntervalOrigin;

    @Override
    public O apply(I kernel, Dimensions paddedDimensions) {
        Dimensions paddedFFTInputDimensions;
        if (this.getFFTSizeOp() != null) {
            long[][] sizes = this.getFFTSizeOp().apply(paddedDimensions);
            paddedFFTInputDimensions = new FinalDimensions(sizes[0]);
        } else {
            paddedFFTInputDimensions = paddedDimensions;
        }
        Interval kernelConvolutionInterval = this.paddingIntervalCentered.apply(kernel, paddedFFTInputDimensions);
        Interval kernelConvolutionIntervalOrigin = this.paddingIntervalOrigin.apply(kernel, kernelConvolutionInterval);
        return (O)Views.interval((RandomAccessible)Views.extendPeriodic((RandomAccessibleInterval)Views.interval((RandomAccessible)Views.extendValue(kernel, (Type)((ComplexType)((ComplexType)Util.getTypeFromInterval(kernel)).createVariable())), (Interval)kernelConvolutionInterval)), (Interval)kernelConvolutionIntervalOrigin);
    }

    protected Function<Dimensions, long[][]> getFFTSizeOp() {
        return null;
    }
}

