/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.sobel;

import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class SobelRAI<T extends RealType<T>>
implements Computers.Arity1<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> {
    @OpDependency(name="create.img")
    private Function<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> createRAI;
    @OpDependency(name="math.sqr")
    private Computers.Arity1<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> squareMapOp;
    @OpDependency(name="math.sqrt")
    private Computers.Arity1<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> sqrtMapOp;
    @OpDependency(name="math.add")
    private Computers.Arity2<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> addOp;
    @OpDependency(name="filter.partialDerivative")
    private Computers.Arity2<RandomAccessibleInterval<T>, Integer, RandomAccessibleInterval<T>> derivativeComputer;

    public void compute(RandomAccessibleInterval<T> input, RandomAccessibleInterval<T> output) {
        for (int i = 0; i < input.numDimensions(); ++i) {
            RandomAccessibleInterval<T> derivative = this.createRAI.apply(input);
            this.derivativeComputer.compute(input, (Object)i, derivative);
            this.squareMapOp.compute(derivative, derivative);
            this.addOp.compute(output, derivative, output);
        }
        this.sqrtMapOp.compute(output, output);
    }
}

