/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.vesselness;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.ArrayList;
import java.util.Comparator;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.AbstractOutOfBoundsMirror;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.function.Computers;
import org.scijava.ops.spi.Nullable;

public class DefaultFrangi<T extends RealType<T>, U extends RealType<U>>
implements Computers.Arity3<RandomAccessibleInterval<T>, Integer, double[], RandomAccessibleInterval<U>> {
    protected double alpha = 0.5;
    protected double beta = 0.5;
    protected double minimumVesselness = Double.MIN_VALUE;
    protected double maximumVesselness = Double.MAX_VALUE;

    private double getDistance(RandomAccess<T> ahead, RandomAccess<T> behind, int d, double[] spacing) {
        double distance = 0.0;
        for (int i = 0; i < d; ++i) {
            double separation = (double)(ahead.getLongPosition(i) - behind.getLongPosition(i)) * spacing[i];
            if (separation == 0.0) continue;
            distance += separation * separation;
        }
        return Math.sqrt(distance);
    }

    private double derive(double val1, double val2, double distance) {
        return (val2 - val1) / distance;
    }

    public void compute(RandomAccessibleInterval<T> input, Integer scale, @Nullable double[] spacing, RandomAccessibleInterval<U> output) {
        if (input.numDimensions() != 2 && input.numDimensions() != 3) {
            throw new IllegalArgumentException("Currently only 2 or 3 dimensional images are supported");
        }
        if (spacing == null) {
            spacing = new double[input.numDimensions()];
            for (int i = 0; i < input.numDimensions(); ++i) {
                spacing[i] = 1.0;
            }
        }
        this.frangi(input, output, spacing, scale);
    }

    private void frangi(RandomAccessibleInterval<T> in, RandomAccessibleInterval<U> out, double[] spacing, int step) {
        double ad = 2.0 * this.alpha * this.alpha;
        double bd = 2.0 * this.beta * this.beta;
        OutOfBoundsMirrorFactory osmf = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
        Cursor cursor = Views.iterable(in).localizingCursor();
        Matrix hessian = new Matrix(in.numDimensions(), in.numDimensions());
        AbstractOutOfBoundsMirror current = osmf.create(in);
        AbstractOutOfBoundsMirror behind = osmf.create(in);
        AbstractOutOfBoundsMirror ahead = osmf.create(in);
        RandomAccess outputRA = out.randomAccess();
        while (cursor.hasNext()) {
            double al2;
            double l2;
            double al1;
            double l1;
            double cd;
            cursor.fwd();
            for (int m = 0; m < in.numDimensions(); ++m) {
                for (int n = 0; n < in.numDimensions(); ++n) {
                    current.setPosition((Localizable)cursor);
                    ahead.setPosition((Localizable)cursor);
                    behind.setPosition((Localizable)cursor);
                    behind.move(-step, m);
                    if (m != n) {
                        behind.move(-step, n);
                    }
                    double derivativeA = this.derive(((RealType)behind.get()).getRealDouble(), ((RealType)current.get()).getRealDouble(), this.getDistance((RandomAccess<T>)behind, (RandomAccess<T>)current, in.numDimensions(), spacing));
                    ahead.move(step, m);
                    if (m != n) {
                        ahead.move(step, n);
                    }
                    double derivativeB = this.derive(((RealType)current.get()).getRealDouble(), ((RealType)ahead.get()).getRealDouble(), this.getDistance((RandomAccess<T>)current, (RandomAccess<T>)ahead, in.numDimensions(), spacing));
                    double derivative2 = this.derive(derivativeA, derivativeB, this.getDistance((RandomAccess<T>)behind, (RandomAccess<T>)ahead, in.numDimensions(), spacing));
                    hessian.set(m, n, derivative2);
                }
            }
            double s = hessian.normF();
            double cn = -(s * s);
            EigenvalueDecomposition e = hessian.eig();
            double[] eigenvaluesArray = e.getRealEigenvalues();
            ArrayList<Double> eigenvaluesArrayList = new ArrayList<Double>();
            for (double d : eigenvaluesArray) {
                eigenvaluesArrayList.add(d);
            }
            eigenvaluesArrayList.sort(Comparator.comparingDouble(Math::abs));
            double v = 0.0;
            if (in.numDimensions() == 2) {
                double c = 15.0;
                cd = 2.0 * c * c;
                l1 = (Double)eigenvaluesArrayList.get(0);
                al1 = Math.abs(l1);
                l2 = (Double)eigenvaluesArrayList.get(1);
                al2 = Math.abs(l2);
                if (l2 < 0.0) {
                    double rb = al1 / al2;
                    double bn = -(rb * rb);
                    v = Math.exp(bn / bd) * (1.0 - Math.exp(cn / cd));
                }
            } else if (in.numDimensions() == 3) {
                double c = 200.0;
                cd = 2.0 * c * c;
                l1 = (Double)eigenvaluesArrayList.get(0);
                al1 = Math.abs(l1);
                l2 = (Double)eigenvaluesArrayList.get(1);
                al2 = Math.abs(l2);
                double l3 = (Double)eigenvaluesArrayList.get(2);
                double al3 = Math.abs(l3);
                if (l3 < 0.0) {
                    double rb = al1 / Math.sqrt(al2 * al3);
                    double ra = al2 / al3;
                    double an = -(ra * ra);
                    double bn = -(rb * rb);
                    v = (1.0 - Math.exp(an / ad)) * Math.exp(bn / bd) * (1.0 - Math.exp(cn / cd));
                }
            } else {
                this.maximumVesselness = Math.max(v, this.maximumVesselness);
                this.minimumVesselness = Math.min(v, this.minimumVesselness);
            }
            outputRA.setPosition((Localizable)cursor);
            ((RealType)outputRA.get()).setReal(v);
        }
    }
}

