/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom;

import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;

public class CentroidII
implements Function<IterableInterval<?>, RealLocalizable> {
    @Override
    public RealLocalizable apply(IterableInterval<?> input) {
        int i;
        int numDimensions = input.numDimensions();
        double[] output = new double[numDimensions];
        Cursor c = input.localizingCursor();
        double[] pos = new double[numDimensions];
        while (c.hasNext()) {
            c.fwd();
            c.localize(pos);
            for (i = 0; i < output.length; ++i) {
                int n = i;
                output[n] = output[n] + pos[i];
            }
        }
        for (i = 0; i < output.length; ++i) {
            output[i] = output[i] / (double)input.size();
        }
        return new RealPoint(output);
    }
}

