/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom;

import java.util.function.Function;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.roi.geom.real.Polygon2D;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ops.spi.OpDependency;

public class CentroidPolygon
implements Function<Polygon2D, RealLocalizable> {
    @OpDependency(name="geom.size")
    private Function<Polygon2D, DoubleType> sizeFunc;

    @Override
    public RealLocalizable apply(Polygon2D input) {
        double area = this.sizeFunc.apply(input).get();
        double cx = 0.0;
        double cy = 0.0;
        for (int i = 0; i < input.numVertices(); ++i) {
            RealLocalizable p0 = input.vertex(i);
            RealLocalizable p1 = input.vertex((i + 1) % input.numVertices());
            double p0_x = p0.getDoublePosition(0);
            double p0_y = p0.getDoublePosition(1);
            double p1_x = p1.getDoublePosition(0);
            double p1_y = p1.getDoublePosition(1);
            cx += (p0_x + p1_x) * (p0_x * p1_y - p1_x * p0_y);
            cy += (p0_y + p1_y) * (p0_x * p1_y - p1_x * p0_y);
        }
        return new RealPoint(new double[]{cx / (area * 6.0), cy / (area * 6.0)});
    }
}

