/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom.geom2d;

import java.util.ArrayList;
import java.util.function.Function;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.roi.geom.real.DefaultWritablePolygon2D;
import net.imglib2.roi.geom.real.Polygon2D;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ops.image.geom.GeomUtils;
import org.scijava.ops.spi.OpDependency;

public class DefaultSmallestEnclosingRectangle
implements Function<Polygon2D, Polygon2D> {
    @OpDependency(name="geom.convexHull")
    private Function<Polygon2D, Polygon2D> convexHullFunc;
    @OpDependency(name="geom.centroid")
    private Function<Polygon2D, RealLocalizable> centroidFunc;
    @OpDependency(name="geom.size")
    private Function<Polygon2D, DoubleType> areaFunc;
    @OpDependency(name="geom.boundingBox")
    private Function<Polygon2D, Polygon2D> boundingBoxFunc;

    private Polygon2D rotate(Polygon2D inPoly, double angle, RealLocalizable center) {
        ArrayList<RealPoint> out = new ArrayList<RealPoint>();
        for (RealLocalizable RealPoint2 : GeomUtils.vertices(inPoly)) {
            double cosTheta = Math.cos(angle);
            double sinTheta = Math.sin(angle);
            double x = cosTheta * (RealPoint2.getDoublePosition(0) - center.getDoublePosition(0)) - sinTheta * (RealPoint2.getDoublePosition(1) - center.getDoublePosition(1)) + center.getDoublePosition(0);
            double y = sinTheta * (RealPoint2.getDoublePosition(0) - center.getDoublePosition(0)) + cosTheta * (RealPoint2.getDoublePosition(1) - center.getDoublePosition(1)) + center.getDoublePosition(1);
            out.add(new RealPoint(new double[]{x, y}));
        }
        return new DefaultWritablePolygon2D(out);
    }

    @Override
    public Polygon2D apply(Polygon2D input) {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null!");
        }
        Polygon2D ch = this.convexHullFunc.apply(input);
        RealLocalizable cog = this.centroidFunc.apply(ch);
        Polygon2D minBounds = input;
        double minArea = Double.POSITIVE_INFINITY;
        for (int i = 1; i < ch.numVertices() - 1; ++i) {
            double angle = Math.atan2(ch.vertex(i).getDoublePosition(1) - ch.vertex(i - 1).getDoublePosition(1), ch.vertex(i).getDoublePosition(0) - ch.vertex(i - 1).getDoublePosition(0));
            Polygon2D rotatedPoly = this.rotate(ch, -angle, cog);
            Polygon2D bounds = this.boundingBoxFunc.apply(rotatedPoly);
            double area = this.areaFunc.apply(bounds).get();
            if (!(area < minArea)) continue;
            minArea = area;
            minBounds = this.rotate(bounds, angle, cog);
        }
        double angle = Math.atan2(ch.vertex(0).getDoublePosition(1) - ch.vertex(ch.numVertices() - 1).getDoublePosition(1), ch.vertex(0).getDoublePosition(0) - ch.vertex(ch.numVertices() - 1).getDoublePosition(0));
        Polygon2D rotatedPoly = this.rotate(ch, -angle, cog);
        Polygon2D bounds = this.boundingBoxFunc.apply(rotatedPoly);
        double area = this.areaFunc.apply(bounds).get();
        if (area < minArea) {
            minArea = area;
            minBounds = this.rotate(bounds, angle, cog);
        }
        return minBounds;
    }
}

