/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.distancetransform;

import java.util.ArrayList;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.RealType;
import org.scijava.concurrent.Parallelization;
import org.scijava.ops.image.image.distancetransform.Phase1Runnable3D;
import org.scijava.ops.image.image.distancetransform.Phase2Runnable3D;
import org.scijava.ops.image.image.distancetransform.Phase3Runnable3D;

public final class DistanceTransform3D {
    private DistanceTransform3D() {
    }

    public static <B extends BooleanType<B>, T extends RealType<T>> void compute(RandomAccessibleInterval<B> in, RandomAccessibleInterval<T> out) {
        int[][][] tempValues = new int[(int)in.dimension(0)][(int)out.dimension(1)][(int)out.dimension(2)];
        ArrayList<Runnable> list = new ArrayList<Runnable>();
        int z = 0;
        while ((long)z < in.dimension(2)) {
            int y = 0;
            while ((long)y < in.dimension(1)) {
                list.add(new Phase1Runnable3D<B>(tempValues, in, y, z));
                ++y;
            }
            ++z;
        }
        Parallelization.getTaskExecutor().runAll(list);
        list.clear();
        int[][][] tempValues_new = new int[(int)in.dimension(0)][(int)out.dimension(1)][(int)out.dimension(2)];
        int z2 = 0;
        while ((long)z2 < in.dimension(2)) {
            int x = 0;
            while ((long)x < in.dimension(0)) {
                list.add(new Phase2Runnable3D<T>(tempValues, tempValues_new, out, x, z2));
                ++x;
            }
            ++z2;
        }
        Parallelization.getTaskExecutor().runAll(list);
        int x = 0;
        while ((long)x < in.dimension(0)) {
            int y = 0;
            while ((long)y < in.dimension(1)) {
                list.add(new Phase3Runnable3D<T>(tempValues_new, out, x, y));
                ++y;
            }
            ++x;
        }
        Parallelization.getTaskExecutor().runAll(list);
    }
}

