/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.distancetransform;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;

class Phase1Runnable2DCal<B extends BooleanType<B>>
implements Runnable {
    private final double[][] tempValues;
    private final RandomAccess<B> raIn;
    private final int y;
    private final double infinite;
    private final int width;
    private final double[] calibration;

    public Phase1Runnable2DCal(double[][] tempValues, RandomAccessibleInterval<B> raIn, int yPos, double[] calibration) {
        this.tempValues = tempValues;
        this.raIn = raIn.randomAccess();
        this.y = yPos;
        this.infinite = calibration[0] * (double)raIn.dimension(0) + calibration[1] * (double)raIn.dimension(1);
        this.width = (int)raIn.dimension(0);
        this.calibration = calibration;
    }

    @Override
    public void run() {
        int x;
        this.raIn.setPosition(0, 0);
        this.raIn.setPosition(this.y, 1);
        this.tempValues[0][this.y] = !((BooleanType)this.raIn.get()).get() ? 0.0 : this.infinite;
        for (x = 1; x < this.width; ++x) {
            this.raIn.setPosition(x, 0);
            this.tempValues[x][this.y] = !((BooleanType)this.raIn.get()).get() ? 0.0 : this.tempValues[x - 1][this.y] + this.calibration[0];
        }
        for (x = this.width - 2; x >= 0; --x) {
            if (!(this.tempValues[x + 1][this.y] < this.tempValues[x][this.y])) continue;
            this.tempValues[x][this.y] = this.calibration[0] + this.tempValues[x + 1][this.y];
        }
    }
}

