/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.labeling.cca;

import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.labeling.ConnectedComponents;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.integer.IntType;
import org.scijava.concurrent.Parallelization;
import org.scijava.function.Functions;
import org.scijava.ops.image.labeling.cca.DefaultLabelIterator;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class DefaultCCA<T extends IntegerType<T>, L, I extends IntegerType<I>>
implements Functions.Arity3<RandomAccessibleInterval<T>, ConnectedComponents.StructuringElement, Iterator<Integer>, ImgLabeling<Integer, IntType>> {
    @OpDependency(name="create.imgLabeling")
    private BiFunction<Dimensions, IntType, ImgLabeling<L, IntType>> imgLabelingCreator;

    public ImgLabeling<Integer, IntType> apply(RandomAccessibleInterval<T> input, ConnectedComponents.StructuringElement se, @Nullable Iterator<Integer> labelGenerator) {
        if (labelGenerator == null) {
            labelGenerator = new DefaultLabelIterator();
        }
        ImgLabeling<L, IntType> output = this.imgLabelingCreator.apply((Dimensions)input, new IntType());
        ExecutorService es = Parallelization.getExecutorService();
        ConnectedComponents.labelAllConnectedComponents(input, output, (Iterator)labelGenerator, (ConnectedComponents.StructuringElement)se, (ExecutorService)es);
        return output;
    }
}

