/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.morphology;

import java.util.Arrays;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.roi.labeling.BoundingBox;
import net.imglib2.type.BooleanType;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.function.Computers;

public class Outline<B extends BooleanType<B>>
implements Computers.Arity2<RandomAccessibleInterval<B>, Boolean, RandomAccessibleInterval<BitType>> {
    public void compute(RandomAccessibleInterval<B> input, Boolean excludeEdges, RandomAccessibleInterval<BitType> output) {
        if (!Intervals.equalDimensions(input, output)) {
            throw new IllegalArgumentException("input and output must have equal dimensions!");
        }
        Cursor inputCursor = Views.iterable(input).localizingCursor();
        long[] coordinates = new long[input.numDimensions()];
        ExtendedRandomAccessibleInterval<B, RandomAccessibleInterval<B>> extendedInput = this.extendInterval(input, excludeEdges);
        RandomAccess outputAccess = output.randomAccess();
        while (inputCursor.hasNext()) {
            inputCursor.fwd();
            inputCursor.localize(coordinates);
            if (!this.isOutline(extendedInput, coordinates)) continue;
            outputAccess.setPosition(coordinates);
            ((BitType)outputAccess.get()).set(((BooleanType)inputCursor.get()).get());
        }
    }

    private ExtendedRandomAccessibleInterval<B, RandomAccessibleInterval<B>> extendInterval(RandomAccessibleInterval<B> interval, boolean excludeEdges) {
        BooleanType type = (BooleanType)((BooleanType)Util.getTypeFromInterval(interval)).createVariable();
        type.set(excludeEdges);
        return Views.extendValue(interval, (Type)type);
    }

    private IntervalView<B> neighbourhoodInterval(ExtendedRandomAccessibleInterval<B, RandomAccessibleInterval<B>> interval, long[] coordinates) {
        int dimensions = interval.numDimensions();
        BoundingBox box = new BoundingBox(dimensions);
        long[] minBounds = Arrays.stream(coordinates).map(c -> c - 1L).toArray();
        long[] maxBounds = Arrays.stream(coordinates).map(c -> c + 1L).toArray();
        box.update(minBounds);
        box.update(maxBounds);
        return Views.offsetInterval(interval, (Interval)box);
    }

    private boolean isAnyBackground(IntervalView<B> neighbourhood) {
        Cursor cursor = neighbourhood.cursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            if (((BooleanType)cursor.get()).get()) continue;
            return true;
        }
        return false;
    }

    private boolean isOutline(ExtendedRandomAccessibleInterval<B, RandomAccessibleInterval<B>> source, long[] coordinates) {
        OutOfBounds access = source.randomAccess();
        access.setPosition(coordinates);
        if (!((BooleanType)access.get()).get()) {
            return false;
        }
        IntervalView<B> neighbourhood = this.neighbourhoodInterval(source, coordinates);
        return this.isAnyBackground(neighbourhood);
    }
}

