/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.morphology.thin;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.type.logic.BitType;
import org.scijava.ops.image.morphology.thin.Abstract3x3NeighbourhoodThinning;
import org.scijava.ops.image.morphology.thin.ThinningStrategy;

public class MorphologicalThinningStrategy
extends Abstract3x3NeighbourhoodThinning {
    public MorphologicalThinningStrategy() {
    }

    public MorphologicalThinningStrategy(boolean foreground) {
        super(foreground);
    }

    @Override
    public boolean removePixel(long[] position, RandomAccessible<BitType> accessible, int iteration) {
        RandomAccess<BitType> access = this.randomAccess(accessible);
        access.setPosition(position);
        boolean[] vals = this.getNeighbourhood(access);
        if (iteration % 4 == 0) {
            return this.top(vals);
        }
        if (iteration % 4 == 1) {
            return this.right(vals);
        }
        if (iteration % 4 == 2) {
            return this.bottom(vals);
        }
        if (iteration % 4 == 3) {
            return this.left(vals);
        }
        return false;
    }

    private boolean top(boolean[] vals) {
        if (vals[1] == this.m_background && vals[2] == this.m_background && vals[8] == this.m_background && vals[4] == this.m_foreground && vals[5] == this.m_foreground && vals[6] == this.m_foreground) {
            return true;
        }
        return vals[1] == this.m_background && vals[2] == this.m_background && vals[3] == this.m_background && vals[5] == this.m_foreground && vals[7] == this.m_foreground;
    }

    private boolean right(boolean[] vals) {
        if (vals[2] == this.m_background && vals[3] == this.m_background && vals[4] == this.m_background && vals[6] == this.m_foreground && vals[7] == this.m_foreground && vals[8] == this.m_foreground) {
            return true;
        }
        return vals[3] == this.m_background && vals[4] == this.m_background && vals[5] == this.m_background && vals[1] == this.m_foreground && vals[7] == this.m_foreground;
    }

    private boolean bottom(boolean[] vals) {
        if (vals[4] == this.m_background && vals[5] == this.m_background && vals[6] == this.m_background && vals[1] == this.m_foreground && vals[2] == this.m_foreground && vals[8] == this.m_foreground) {
            return true;
        }
        return vals[5] == this.m_background && vals[6] == this.m_background && vals[7] == this.m_background && vals[1] == this.m_foreground && vals[3] == this.m_foreground;
    }

    private boolean left(boolean[] vals) {
        if (vals[8] == this.m_background && vals[7] == this.m_background && vals[6] == this.m_background && vals[2] == this.m_foreground && vals[3] == this.m_foreground && vals[4] == this.m_foreground) {
            return true;
        }
        return vals[7] == this.m_background && vals[8] == this.m_background && vals[1] == this.m_background && vals[5] == this.m_foreground && vals[3] == this.m_foreground;
    }

    @Override
    public int getIterationsPerCycle() {
        return 4;
    }

    @Override
    public ThinningStrategy copy() {
        return new MorphologicalThinningStrategy(this.m_foreground);
    }
}

