/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.segment.detectRidges;

import net.imglib2.Cursor;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealPoint;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;

public final class RidgeDetectionUtils {
    private RidgeDetectionUtils() {
    }

    protected static double getAngle(double x, double y) {
        double angle = 0.0;
        if (y > 0.0 && x == 0.0) {
            angle = 90.0;
        } else if (y < 0.0 && x == 0.0) {
            angle = 270.0;
        } else {
            angle = Math.atan(y / x) * 180.0 / Math.PI;
            if (x < 0.0) {
                angle += 180.0;
            }
            if (angle < 0.0) {
                angle += 360.0;
            }
        }
        return angle;
    }

    protected static int getOctant(double x, double y) {
        int octant = 1;
        for (double angle = RidgeDetectionUtils.getAngle(x, y); angle > 22.5; angle -= 45.0) {
            ++octant;
        }
        while (octant > 8) {
            octant -= 8;
        }
        while (octant < 1) {
            octant += 8;
        }
        return octant;
    }

    protected static int[] getOctantCoords(int octant) {
        int[] coords = new int[2];
        switch (octant) {
            case 1: 
            case 9: {
                coords[0] = 1;
                break;
            }
            case 2: 
            case 10: {
                coords[0] = 1;
                coords[1] = 1;
                break;
            }
            case 3: 
            case 11: {
                coords[1] = 1;
                break;
            }
            case 4: 
            case 12: {
                coords[0] = -1;
                coords[1] = 1;
                break;
            }
            case 5: {
                coords[0] = -1;
                break;
            }
            case 6: {
                coords[0] = -1;
                coords[1] = -1;
                break;
            }
            case -1: 
            case 7: {
                coords[1] = -1;
                break;
            }
            case 0: 
            case 8: {
                coords[0] = 1;
                coords[1] = -1;
            }
        }
        return coords;
    }

    protected static Point get2DPoint(RandomAccess<DoubleType> RA) {
        long[] coords = new long[]{RA.getLongPosition(0), RA.getLongPosition(1)};
        return new Point(coords);
    }

    protected static RealPoint get2DRealPoint(RandomAccess<DoubleType> RA) {
        double[] coords = new double[]{RA.getDoublePosition(0), RA.getDoublePosition(1)};
        return new RealPoint(coords);
    }

    protected static RealPoint get2DRealPoint(double x, double y) {
        return new RealPoint(new double[]{x, y});
    }

    protected static long[] getMaxCoords(RandomAccessibleInterval<DoubleType> input, boolean useAbsoluteValue) {
        long[] dims = new long[input.numDimensions()];
        double max = Double.MIN_VALUE;
        Cursor cursor = Views.iterable(input).localizingCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            double d = useAbsoluteValue ? Math.abs(((DoubleType)cursor.get()).get()) : ((DoubleType)cursor.get()).get();
            double current = d;
            if (!(current > max)) continue;
            max = current;
            for (int d2 = 0; d2 < input.numDimensions(); ++d2) {
                dims[d2] = cursor.getLongPosition(d2);
            }
        }
        return dims;
    }
}

