/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import java.util.List;
import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import net.imglib2.util.ValuePair;

public class DefaultMinMax<I extends RealType<I>>
implements Function<RandomAccessibleInterval<I>, Pair<I, I>> {
    @Override
    public Pair<I, I> apply(RandomAccessibleInterval<I> input) {
        RealType minVal = (RealType)((RealType)Util.getTypeFromInterval(input)).createVariable();
        minVal.setReal(minVal.getMinValue());
        RealType maxVal = (RealType)minVal.createVariable();
        maxVal.setReal(maxVal.getMaxValue());
        List minMaxes = LoopBuilder.setImages(input).multiThreaded().forEachChunk(chunk -> {
            RealType min = (RealType)maxVal.copy();
            RealType max = (RealType)minVal.copy();
            chunk.forEachPixel(in -> {
                if (in.compareTo((Object)min) < 0) {
                    min.set((Type)in);
                }
                if (in.compareTo((Object)max) > 0) {
                    max.set((Type)in);
                }
            });
            return new ValuePair((Object)min, (Object)max);
        });
        RealType raiMin = minMaxes.parallelStream().map(pair -> (RealType)pair.getA()).reduce(maxVal, (result, min) -> min.compareTo(result) < 0 ? min : result);
        RealType raiMax = minMaxes.parallelStream().map(pair -> (RealType)pair.getB()).reduce(minVal, (result, max) -> max.compareTo(result) > 0 ? max : result);
        return new ValuePair((Object)raiMin, (Object)raiMax);
    }
}

