/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import java.util.function.BiFunction;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.RealType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class DefaultSumOfInverses<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity2<RandomAccessibleInterval<I>, O, O> {
    @OpDependency(name="create.img")
    private BiFunction<Dimensions, O, RandomAccessibleInterval<O>> imgCreator;
    @OpDependency(name="math.reciprocal")
    private Computers.Arity2<I, Double, O> reciprocalOp;
    @OpDependency(name="stats.sum")
    private Computers.Arity1<RandomAccessibleInterval<O>, O> sumOp;

    public void compute(RandomAccessibleInterval<I> input, O dbzValue, O output) {
        RandomAccessibleInterval<O> tmpImg = this.imgCreator.apply((Dimensions)input, output);
        LoopBuilder.setImages(input, tmpImg).multiThreaded().forEachPixel((inPixel, outPixel) -> this.reciprocalOp.compute(inPixel, (Object)dbzValue.getRealDouble(), outPixel));
        this.sumOp.compute(tmpImg, output);
    }
}

