/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import java.util.function.BiFunction;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class DefaultSumOfLogs<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity1<RandomAccessibleInterval<I>, O> {
    @OpDependency(name="create.img")
    private BiFunction<Dimensions, DoubleType, RandomAccessibleInterval<DoubleType>> imgCreator;
    @OpDependency(name="math.log")
    private Computers.Arity1<RandomAccessibleInterval<I>, RandomAccessibleInterval<DoubleType>> logOp;
    @OpDependency(name="stats.sum")
    private Computers.Arity1<RandomAccessibleInterval<DoubleType>, O> sumOp;

    public void compute(RandomAccessibleInterval<I> input, O sumOfLogs) {
        RandomAccessibleInterval<DoubleType> logImg = this.imgCreator.apply((Dimensions)input, new DoubleType());
        this.logOp.compute(input, logImg);
        this.sumOp.compute(logImg, sumOfLogs);
    }
}

