/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import net.imglib2.Dimensions;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.converter.RealDoubleConverter;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Intervals;
import net.imglib2.view.composite.Composite;
import org.scijava.function.Computers;
import org.scijava.ops.image.image.integral.IntegralCursor;

public class IntegralMean<I extends RealType<I>>
implements Computers.Arity1<RectangleNeighborhood<? extends Composite<I>>, DoubleType> {
    public void compute(RectangleNeighborhood<? extends Composite<I>> input, DoubleType integralMean) {
        IntegralCursor<Composite<I>> cursor = new IntegralCursor<Composite<I>>(input);
        int dimensions = input.numDimensions();
        DoubleType sum = new DoubleType();
        sum.setZero();
        RealDoubleConverter conv = new RealDoubleConverter();
        DoubleType valueAsDoubleType = new DoubleType();
        while (cursor.hasNext()) {
            RealType value = (RealType)((RealType)cursor.next().get(0L)).copy();
            conv.convert((Object)value, (Object)valueAsDoubleType);
            int cornerInteger = cursor.getCornerRepresentation();
            DoubleType factor = new DoubleType(Math.pow(-1.0, dimensions - IntegralMean.norm(cornerInteger)));
            valueAsDoubleType.mul((AbstractRealType)factor);
            sum.add((AbstractRealType)valueAsDoubleType);
        }
        int area = (int)Intervals.numElements((Dimensions)Intervals.expand(input, (long)-1L));
        valueAsDoubleType.set((double)area);
        sum.div((AbstractRealType)valueAsDoubleType);
        integralMean.set((AbstractRealType)sum);
    }

    public static int norm(int cornerPosition) {
        return Integer.bitCount(cornerPosition);
    }
}

