/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.intermodes;

import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.ops.image.threshold.AbstractComputeThresholdHistogram;
import org.scijava.ops.image.threshold.Thresholds;
import org.scijava.ops.spi.OpExecutionException;

public class ComputeIntermodesThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T> {
    @Override
    public long computeBin(Histogram1d<T> hist) {
        long[] histogram = hist.toLongArray();
        return ComputeIntermodesThreshold.computeBin(histogram);
    }

    public static long computeBin(long[] histogram) {
        double[] iHisto = new double[histogram.length];
        int iter = 0;
        int threshold = -1;
        for (int i = 0; i < histogram.length; ++i) {
            iHisto[i] = histogram[i];
        }
        while (!Thresholds.bimodalTest(iHisto)) {
            double previous = 0.0;
            double current = 0.0;
            double next = iHisto[0];
            for (int i = 0; i < histogram.length - 1; ++i) {
                previous = current;
                current = next;
                next = iHisto[i + 1];
                iHisto[i] = (previous + current + next) / 3.0;
            }
            iHisto[histogram.length - 1] = (current + next) / 3.0;
            if (++iter <= 10000) continue;
            throw new OpExecutionException("Intermodes Threshold not found after 10000 iterations.");
        }
        int tt = 0;
        for (int i = 1; i < histogram.length - 1; ++i) {
            if (!(iHisto[i - 1] < iHisto[i]) || !(iHisto[i + 1] < iHisto[i])) continue;
            tt += i;
        }
        threshold = (int)Math.floor((double)tt / 2.0);
        return threshold;
    }
}

