/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.isoData;

import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.ops.image.threshold.AbstractComputeThresholdHistogram;
import org.scijava.ops.spi.OpExecutionException;

public class ComputeIsoDataThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T> {
    @Override
    public long computeBin(Histogram1d<T> hist) {
        long[] histogram = hist.toLongArray();
        return ComputeIsoDataThreshold.computeBin(histogram);
    }

    public static long computeBin(long[] histogram) {
        int g;
        block4: {
            int i;
            g = 0;
            for (i = 1; i < histogram.length; ++i) {
                if (histogram[i] <= 0L) continue;
                g = i + 1;
                break;
            }
            do {
                long l = 0L;
                long totl = 0L;
                for (i = 0; i < g; ++i) {
                    totl += histogram[i];
                    l += histogram[i] * (long)i;
                }
                long h = 0L;
                long toth = 0L;
                for (i = g + 1; i < histogram.length; ++i) {
                    toth += histogram[i];
                    h += histogram[i] * (long)i;
                }
                if (totl > 0L && toth > 0L && g == (int)Math.round((double)((l /= totl) + (h /= toth)) / 2.0)) break block4;
            } while (++g <= histogram.length - 2);
            throw new OpExecutionException("IsoData Threshold not found.");
        }
        return g;
    }
}

