/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.localBernsen;

import java.util.function.Function;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class ComputeLocalBernsenThreshold<T extends RealType<T>>
implements Computers.Arity4<Iterable<T>, T, Double, Double, BitType> {
    @OpDependency(name="stats.minMax")
    private Function<Iterable<T>, Pair<T, T>> minMaxOp;

    public void compute(Iterable<T> inputNeighborhood, T inputCenterPixel, Double contrastThreshold, Double halfMaxValue, BitType output) {
        ComputeLocalBernsenThreshold.compute(inputNeighborhood, inputCenterPixel, contrastThreshold, halfMaxValue, this.minMaxOp, output);
    }

    public static <T extends RealType<T>> void compute(Iterable<T> inputNeighborhood, T inputCenterPixel, Double contrastThreshold, Double halfMaxValue, Function<Iterable<T>, Pair<T, T>> minMaxOp, BitType output) {
        Pair<T, T> outputs = minMaxOp.apply(inputNeighborhood);
        double minValue = ((RealType)outputs.getA()).getRealDouble();
        double maxValue = ((RealType)outputs.getB()).getRealDouble();
        double midGrey = (maxValue + minValue) / 2.0;
        if (maxValue - minValue < contrastThreshold) {
            output.set(midGrey >= halfMaxValue);
        } else {
            output.set(inputCenterPixel.getRealDouble() >= midGrey);
        }
    }
}

