/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.localMean;

import java.util.Arrays;
import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.composite.Composite;
import org.scijava.function.Computers;
import org.scijava.ops.image.threshold.ApplyLocalThresholdIntegral;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class LocalMeanThreshold<T extends RealType<T>>
extends ApplyLocalThresholdIntegral<T, DoubleType>
implements Computers.Arity4<RandomAccessibleInterval<T>, Shape, Double, OutOfBoundsFactory<T, RandomAccessibleInterval<T>>, RandomAccessibleInterval<BitType>> {
    private static final int INTEGRAL_IMAGE_ORDER = 1;
    @OpDependency(name="threshold.localMean")
    private Computers.Arity3<Iterable<T>, T, Double, BitType> computeThresholdNonIntegralOp;
    @OpDependency(name="threshold.localMean")
    private Computers.Arity3<RectangleNeighborhood<? extends Composite<DoubleType>>, T, Double, BitType> computeThresholdIntegralOp;
    @OpDependency(name="filter.applyCenterAware")
    private Computers.Arity4<RandomAccessibleInterval<T>, Computers.Arity2<Iterable<T>, T, BitType>, Shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>>, RandomAccessibleInterval<BitType>> applyFilterOp;

    public void compute(RandomAccessibleInterval<T> input, Shape inputNeighborhoodShape, Double c, @Nullable OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory, RandomAccessibleInterval<BitType> output) {
        RectangleShape rShape;
        RectangleShape rectangleShape = rShape = inputNeighborhoodShape instanceof RectangleShape ? (RectangleShape)inputNeighborhoodShape : null;
        if (rShape != null && rShape.getSpan() > 2 && !rShape.isSkippingCenter()) {
            this.computeIntegral(input, rShape, c, outOfBoundsFactory, this.getIntegralImageOp(1), this.computeThresholdIntegralOp, output);
        } else {
            this.computeNonIntegral(input, inputNeighborhoodShape, c, outOfBoundsFactory, this.computeThresholdNonIntegralOp, output);
        }
    }

    public void computeNonIntegral(RandomAccessibleInterval<T> input, Shape inputNeighborhoodShape, Double c, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory, Computers.Arity3<Iterable<T>, T, Double, BitType> computeThresholdOp, RandomAccessibleInterval<BitType> output) {
        Computers.Arity2 parameterizedComputeThresholdOp = (i1, i2, o) -> computeThresholdOp.compute(i1, i2, (Object)c, o);
        this.applyFilterOp.compute(input, (Object)parameterizedComputeThresholdOp, (Object)inputNeighborhoodShape, outOfBoundsFactory, output);
    }

    public void computeIntegral(RandomAccessibleInterval<T> input, RectangleShape inputNeighborhoodShape, Double c, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory, Function<RandomAccessibleInterval<T>, RandomAccessibleInterval<DoubleType>> integralImageOp, Computers.Arity3<RectangleNeighborhood<? extends Composite<DoubleType>>, T, Double, BitType> computeThresholdOp, RandomAccessibleInterval<BitType> output) {
        Computers.Arity2 parameterizedComputeThresholdOp = (i1, i2, o) -> computeThresholdOp.compute(i1, i2, (Object)c, o);
        this.compute(input, inputNeighborhoodShape, outOfBoundsFactory, Arrays.asList(integralImageOp), parameterizedComputeThresholdOp, output);
    }
}

