/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.maxLikelihood;

import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.ops.image.threshold.AbstractComputeThresholdHistogram;
import org.scijava.ops.image.threshold.Thresholds;
import org.scijava.ops.image.threshold.minimum.ComputeMinimumThreshold;

public class ComputeMaxLikelihoodThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T> {
    private static final int MAX_ATTEMPTS = 10000;

    @Override
    public long computeBin(Histogram1d<T> hist) {
        long[] histogram = hist.toLongArray();
        return ComputeMaxLikelihoodThreshold.computeBin(histogram);
    }

    public static long computeBin(long[] histogram) {
        int n = histogram.length - 1;
        long[] y = histogram;
        int T = (int)ComputeMinimumThreshold.computeBin(histogram);
        if (T < 0) {
            return 0L;
        }
        double eps = 1.0E-7;
        double mu = Thresholds.B(y, T) / Thresholds.A(y, T);
        double nu = (Thresholds.B(y, n) - Thresholds.B(y, T)) / (Thresholds.A(y, n) - Thresholds.A(y, T));
        double p = Thresholds.A(y, T) / Thresholds.A(y, n);
        double q = (Thresholds.A(y, n) - Thresholds.A(y, T)) / Thresholds.A(y, n);
        double sigma2 = Thresholds.C(y, T) / Thresholds.A(y, T) - mu * mu;
        double tau2 = (Thresholds.C(y, n) - Thresholds.C(y, T)) / (Thresholds.A(y, n) - Thresholds.A(y, T)) - nu * nu;
        if (sigma2 == 0.0 || tau2 == 0.0) {
            return 0L;
        }
        double mu_prev = Double.NaN;
        double nu_prev = Double.NaN;
        double p_prev = Double.NaN;
        double q_prev = Double.NaN;
        double sigma2_prev = Double.NaN;
        double tau2_prev = Double.NaN;
        double[] ind = ComputeMaxLikelihoodThreshold.indices(n + 1);
        double[] ind2 = new double[n + 1];
        double[] phi = new double[n + 1];
        double[] gamma = new double[n + 1];
        double[] tmp1 = new double[n + 1];
        double[] tmp2 = new double[n + 1];
        double[] tmp3 = new double[n + 1];
        double[] tmp4 = new double[n + 1];
        ComputeMaxLikelihoodThreshold.sqr(ind, ind2);
        int attempts = 0;
        do {
            if (attempts++ > 10000) {
                throw new IllegalStateException("Max likelihood method not converging after 10000 attempts.");
            }
            for (int i = 0; i <= n; ++i) {
                double dmu2 = ((double)i - mu) * ((double)i - mu);
                double dnu2 = ((double)i - nu) * ((double)i - nu);
                phi[i] = p / Math.sqrt(sigma2) * Math.exp(-dmu2 / (2.0 * sigma2)) / (p / Math.sqrt(sigma2) * Math.exp(-dmu2 / (2.0 * sigma2)) + q / Math.sqrt(tau2) * Math.exp(-dnu2 / (2.0 * tau2)));
            }
            ComputeMaxLikelihoodThreshold.minus(1L, phi, gamma);
            double F = ComputeMaxLikelihoodThreshold.mul(phi, y);
            double G = ComputeMaxLikelihoodThreshold.mul(gamma, y);
            p_prev = p;
            q_prev = q;
            mu_prev = mu;
            nu_prev = nu;
            sigma2_prev = nu;
            tau2_prev = nu;
            double Ayn = Thresholds.A(y, n);
            p = F / Ayn;
            q = G / Ayn;
            ComputeMaxLikelihoodThreshold.scale(ind, phi, tmp1);
            mu = ComputeMaxLikelihoodThreshold.mul(tmp1, y) / F;
            ComputeMaxLikelihoodThreshold.scale(ind, gamma, tmp2);
            nu = ComputeMaxLikelihoodThreshold.mul(tmp2, y) / G;
            ComputeMaxLikelihoodThreshold.scale(ind2, phi, tmp3);
            sigma2 = ComputeMaxLikelihoodThreshold.mul(tmp3, y) / F - mu * mu;
            ComputeMaxLikelihoodThreshold.scale(ind2, gamma, tmp4);
            tau2 = ComputeMaxLikelihoodThreshold.mul(tmp4, y) / G - nu * nu;
        } while (!(Math.abs(mu - mu_prev) < 1.0E-7 || Math.abs(nu - nu_prev) < 1.0E-7 || Math.abs(p - p_prev) < 1.0E-7 || Math.abs(q - q_prev) < 1.0E-7 || Math.abs(sigma2 - sigma2_prev) < 1.0E-7) && !(Math.abs(tau2 - tau2_prev) < 1.0E-7));
        double w1 = mu / sigma2 - nu / tau2;
        double w0 = 1.0 / sigma2 - 1.0 / tau2;
        double w2 = mu * mu / sigma2 - nu * nu / tau2 + Math.log10(sigma2 * (q * q) / (tau2 * (p * p)));
        double sqterm = w1 * w1 - w0 * w2;
        if (sqterm < 0.0) {
            throw new IllegalStateException("Max likelihood threshold would be imaginary");
        }
        return (int)Math.floor((w1 + Math.sqrt(sqterm)) / w0);
    }

    private static double mul(double[] row, long[] col) {
        if (row.length != col.length) {
            throw new IllegalArgumentException("row/col lengths differ");
        }
        double sum = 0.0;
        for (int i = 0; i < row.length; ++i) {
            sum += row[i] * (double)col[i];
        }
        return sum;
    }

    private static void scale(double[] list1, double[] list2, double[] output) {
        if (list1.length != list2.length || list1.length != output.length) {
            throw new IllegalArgumentException("list lengths differ");
        }
        for (int i = 0; i < list1.length; ++i) {
            output[i] = list1[i] * list2[i];
        }
    }

    private static void sqr(double[] in, double[] out) {
        if (in.length != out.length) {
            throw new IllegalArgumentException("list lengths differ");
        }
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i] * in[i];
        }
    }

    private static double[] indices(int n) {
        double[] indices = new double[n];
        for (int i = 0; i < n; ++i) {
            indices[i] = i;
        }
        return indices;
    }

    private static void minus(long num, double[] phi, double[] gamma) {
        if (phi.length != gamma.length) {
            throw new IllegalArgumentException("list lengths differ");
        }
        for (int i = 0; i < phi.length; ++i) {
            gamma[i] = (double)num - phi[i];
        }
    }
}

