/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.mean;

import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.ops.image.threshold.AbstractComputeThresholdHistogram;

public class ComputeMeanThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T> {
    @Override
    public long computeBin(Histogram1d<T> hist) {
        long[] histogram = hist.toLongArray();
        return ComputeMeanThreshold.computeBin(histogram);
    }

    public static long computeBin(long[] histogram) {
        int threshold = -1;
        double tot = 0.0;
        double sum = 0.0;
        for (int i = 0; i < histogram.length; ++i) {
            tot += (double)histogram[i];
            sum += (double)((long)i * histogram[i]);
        }
        threshold = (int)Math.floor(sum / tot);
        return threshold;
    }
}

