/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.Vector;
import org.simdjson.JsonParsingException;
import org.simdjson.JsonStringBlock;
import org.simdjson.StructuralIndexer;

class JsonStringScanner {
    private static final long EVEN_BITS_MASK = 0x5555555555555555L;
    private static final long ODD_BITS_MASK = -6148914691236517206L;
    private final ByteVector backslashMask = ByteVector.broadcast(StructuralIndexer.SPECIES, (byte)92);
    private final ByteVector quoteMask = ByteVector.broadcast(StructuralIndexer.SPECIES, (byte)34);
    private long prevInString = 0L;
    private long prevEscaped = 0L;

    JsonStringScanner() {
    }

    JsonStringBlock next(ByteVector chunk0) {
        long backslash = this.eq(chunk0, this.backslashMask);
        long escaped = this.findEscaped(backslash);
        long quote = this.eq(chunk0, this.quoteMask) & (escaped ^ 0xFFFFFFFFFFFFFFFFL);
        long inString = this.prefixXor(quote) ^ this.prevInString;
        this.prevInString = inString >> 63;
        return new JsonStringBlock(quote, inString);
    }

    JsonStringBlock next(ByteVector chunk0, ByteVector chunk1) {
        long backslash = this.eq(chunk0, chunk1, this.backslashMask);
        long escaped = this.findEscaped(backslash);
        long quote = this.eq(chunk0, chunk1, this.quoteMask) & (escaped ^ 0xFFFFFFFFFFFFFFFFL);
        long inString = this.prefixXor(quote) ^ this.prevInString;
        this.prevInString = inString >> 63;
        return new JsonStringBlock(quote, inString);
    }

    private long eq(ByteVector chunk0, ByteVector mask) {
        long r = chunk0.eq((Vector)mask).toLong();
        return r;
    }

    private long eq(ByteVector chunk0, ByteVector chunk1, ByteVector mask) {
        long r0 = chunk0.eq((Vector)mask).toLong();
        long r1 = chunk1.eq((Vector)mask).toLong();
        return r0 | r1 << 32;
    }

    private long findEscaped(long backslash) {
        if (backslash == 0L) {
            long escaped = this.prevEscaped;
            this.prevEscaped = 0L;
            return escaped;
        }
        long followsEscape = (backslash &= this.prevEscaped ^ 0xFFFFFFFFFFFFFFFFL) << 1 | this.prevEscaped;
        long oddSequenceStarts = backslash & 0xAAAAAAAAAAAAAAAAL & (followsEscape ^ 0xFFFFFFFFFFFFFFFFL);
        long sequencesStartingOnEvenBits = oddSequenceStarts + backslash;
        this.prevEscaped = (oddSequenceStarts >>> 1) + (backslash >>> 1) + (oddSequenceStarts & backslash & 1L) >>> 63;
        long invertMask = sequencesStartingOnEvenBits << 1;
        return (0x5555555555555555L ^ invertMask) & followsEscape;
    }

    private long prefixXor(long bitmask) {
        bitmask ^= bitmask << 1;
        bitmask ^= bitmask << 2;
        bitmask ^= bitmask << 4;
        bitmask ^= bitmask << 8;
        bitmask ^= bitmask << 16;
        bitmask ^= bitmask << 32;
        return bitmask;
    }

    void reset() {
        this.prevInString = 0L;
        this.prevEscaped = 0L;
    }

    void finish() {
        if (this.prevInString != 0L) {
            throw new JsonParsingException("Unclosed string. A string is opened, but never closed.");
        }
    }
}

